function g = chainABCD(n, nhat, B2, C2, D12, D21, GA, GB, GC, GD)
% Construct the gradient with respect to the parameterization specified
% in function getABCDbig, via chain rule.
% The complex gradients of the objective function of Abig, Bbig, Cbig, Dbig
% are given by GA, GB, GC, GD respectively. In principle, the objective
% function could be any function, but we are interested in two cases: the
% H-infinity norm (see hinfty.m) and the spectral abscissa (see specabsc.m;
% in this case GB, GC and GD are all trivially zero).

% Derivation of chain rule is from first principles: 
% f(Q + M(X+DeltaX) N) is approx f(Q  + MXN) + <del f, M DeltaX N> and the 
% latter is real tr G' M DeltaX N = real tr N G' M DeltaX = <M' G N', DeltaX>,
% where G is the gradient of f in matrix space.  Thus the gradient wrt X
% of f(Q + MXN) is M'GN'; equivalently, the gradient wrt vec(X) is vec(M'GN').

% Note: the reason we take the real part is not because of the real inner
% product on complex matrix space.  It's because the parameter space is always
% real, even though the matrix functions may be complex.  Usually the matrix
% functions are also real, but of course the eigenvalues are generally complex.

indx1 = 1:n;
indx2 = n + 1 : n + nhat;

delAbigAhat = real(GA(indx2,indx2));         % [0  I]*GA*[I; 0]
delAbigBhat = real(GA(indx2,indx1)*C2');     % etc
delAbigChat = real(B2'*GA(indx1,indx2));     % etc
delAbigDhat = real(B2'*GA(indx1,indx1)*C2'); % [B2' 0]*GA*[C2'; 0]
delBbigBhat = real(GB(indx2,:)*D21');     % GB*[0; D21']     (delBbigAhat is 0)                                          
delBbigDhat = real(B2'*GB(indx1,:)*D21'); % B2'*GB*[D21'; 0] (delBbigChat is 0)
delCbigChat = real(D12'*GC(:,indx2));     % (delCbigAhat, delCbigBhat are 0)
delCbigDhat = real(D12'*GC(:,indx1)*C2');
delDbigDhat = real(D12'*GD*D21');         % (rest are 0)
delAhat = delAbigAhat;
delBhat = delAbigBhat + delBbigBhat;
delChat = delAbigChat + delCbigChat;
delDhat = delAbigDhat + delBbigDhat + delCbigDhat + delDbigDhat;
g = putABCDhat(delAhat, delBhat, delChat, delDhat);

