function testhanso2_1(wantpause)
if nargin < 1
    wantpause = 0;
end
fprintf(' test suite for HANSO 2.1\n')
fprintf(' mostly same as suite for HANSO 2.0 except that limited memory BFGS invoked explicitly at end\n')
fprintf(' default is 10 BFGS starting points followed by gradient sampling with \n')
fprintf(' 3 sampling radius values if termination criterion at best point found\n')
fprintf(' is not verified in BFGS phase, AND number of variables <= 100\n')
fprintf(' \n')
fprintf(' Nesterov SMOOTH Chebyshev-Rosenbrock function\n')
fprintf(' this is very hard so sometimes the optimality termination is satisfied\n')
fprintf(' not by norm of gradient being small but norm of smallest vector in convex\n')
fprintf(' hull of gradients small, even though f is actually smooth\n')
pars = pars_yurirosen(7)

fprintf(' start by giving too few max iterations for BFGS so gradient sampling has\n')
fprintf(' the opportunity to make an improvement\n')
options.normtol = 1e-6;
options.maxit = 100;
[x, f, loc, X, G, w, H] = hanso(pars,options);  % hanso echos options

if wantpause, fprintf('\n\nhit any key to continue\n'), pause, end
fprintf(' now the default options (normtol 1e-4, maxit 1000)\n')
pars = pars_yurirosen(7)
[x, f, loc, X, G, w, H] = hanso(pars);

if wantpause, fprintf('\n\nhit any key to continue\n'), pause, end
fprintf(' reduce tolerance and increase maximum iterations for BFGS\n')
options.normtol = 1e-6;
options.maxit = 10000;
[x, f, loc, X, G, w, H] = hanso(pars,options);

if wantpause, fprintf('\n\nhit any key to continue\n'), pause, end
fprintf(' Nesterov FIRST NONSMOOTH Chebyshev-Rosenbrock function\n')
fprintf(' this is partly smooth and the only Clarke stationary point is the local\n')
fprintf(' minimizer, but the problem is tough even for n=3\n')
pars = pars_yurirosen_ns1(3)
[x, f, loc, X, G, w, H] = hanso(pars);

if wantpause, fprintf('\n\nhit any key to continue\n'), pause, end
fprintf(' Nesterov SECOND NONSMOOTH Chebyshev-Rosenbrock function\n')
fprintf(' this is not regular and hence has multiple Clarke stationary points, note\n')
fprintf(' how different starting points result in termination at any one of 4\n')
fprintf(' stationary points for n=3\n')
pars = pars_yurirosen_ns2(3)
[x, f, loc, X, G, w, H] = hanso(pars);

if wantpause, fprintf('\n\nhit any key to continue\n'), pause, end
fprintf(' Anstreicher-Lee eigenvalue product - 25 variables (nonsmooth)\n')
% in the call to parsdef, the first 5 refers to the size of the matrix and
% the second 5 to the rank: this is better than an alternative way of posing
% the full rank problem as explained in the comments
pars = parsdef(5,5,1) % 1 (jon36), not 0, as 5,5,0 is a smooth problem
[x, f, loc, X, G, w, H] = hanso(pars);

if wantpause, fprintf('\n\nhit any key to continue\n'), pause, end
fprintf(' Anstreicher-Lee eigenvalue product - 100 variables (nonsmooth)\n')
pars = parsdef(10,10,0)  % 0 is the default: kurt63
[x, f, loc, X, G, w, H] = hanso(pars);

if wantpause, fprintf('\n\nhit any key to continue\n'), pause, end
fprintf(' Anstreicher-Lee eigenvalue product - 400 variables (nonsmooth)')
fprintf(' takes longer, so use only one starting point\n')
pars = parsdef(20,20,0) % 0 is the default: kurt63
clear options
options.x0 = randn(pars.nvar,1);
[x, f, loc, X, G, w, H] = hanso(pars,options);

if wantpause, fprintf('\n\nhit any key to continue\n'), pause, end
fprintf(' Anstreicher-Lee eigenvalue product - 400 variables again, but this time explicitly\n')
fprintf(' call limited memory BFGS, which is faster, but does not get such a good answer\n')
pars = parsdef(20,20,0) % 0 is the default: kurt63
clear options
options.x0 = randn(pars.nvar,1);
options.nvec = 10; % limited memory saving 10 vector pairs
[x, f, loc, X, G, w, H] = hanso(pars,options);

