function pars = pars_easyfun(n1, n2, wcond)
pars.n1 = n1;
pars.n2 = n2;
n = n1+n2;
pars.nvar = n;
if nargin < 3
    w = ones(n1+n2,1);
else
    w1 = 1;
    wn = wcond;
    w = linspace(1,wcond,n)';
    w = w.*rand(n,1);
end
pars.w = w;
if min([n1,n2,w']) < 0
    error('parameters must be nonnegative')
end
pars.fgname = 'easyfun';
if all(w == 1) && n2 == 0 % all w = 1 and n1 = 0 is not interesting
    pars.title = sprintf(...
    'sum_{1..n}|x_i|, n=%d',n1);
elseif all(w == 1) % all w = 1 and n1 = 0 is not interesting
    pars.title = sprintf(...
    'sum_{1..n1}|x_i| + sum_{n1+1..n1+n2} 0.5 x_i^2,n1=%d, n2=%d',n1,n2);
elseif n1 == 0
    wcond_actual = round(max(w)/min(w));
    pars.title = sprintf(...
    'sum_{1..n} 0.5 w_i x_i^2,n=%d,cond(w)=%g',n2,wcond_actual);
elseif n2 == 0
    wcond_actual = round(max(w)/min(w));
    pars.title = sprintf(...
    'sum_{1..n} 0.5 w_i |x_i|,n=%d,cond(w)=%g',n1,wcond_actual);
else
    pars.title = sprintf(...
    'sum_{1..n1} w_i |x_i| + sum_{n1+1..n1+n2} 0.5 w_i x_i^2,n1=%d, n2=%d',n1,n2);
end