function easyfun_driver(n1,n2)
% a simple test of HANSO
if nargin < 2
    n2 = 5;
end
if nargin < 1
    n1 = 3;
end
fprintf('First easy test problem: HANSO calls BFGS starting from 10 randomly generated starting points\n\n')
pars = pars_easyfun(n1,n2);
[x,f] = hanso(pars); % or hanso(pars,options): see documentation (type "help hanso")
%
fprintf('\nSecond easy test problem: HANSO calls BFGS starting from 10 randomly generated starting points\n\n')
pars = pars_easyfun2(n1,n2);
[x,f] = hanso(pars); % or hanso(pars,options): see documentation (type "help hanso")
%
fprintf('\nSecond easy test problem: HANSO calls BFGS starting from 1 randomly generated starting point, followed by a Gradient Sampling Phase\n\n')
pars = pars_easyfun2(n1,n2);
options.x0 = randn(pars.nvar,1);
options.maxit_gradsamp = 1000;
[x,f] = hanso(pars,options); % see documentation (type "help hanso")