function  [A, n, blkloc] = gnsdgen(index, nblks, blksz, smin)

if nblks~=index && nblks~=index+1
   error('The number of blocks must equal index or index+1.')
end
if nblks > max(size(blksz))
   error('The array blksz is to small.')
end

for j=2:index
   if blksz(j-1)<blksz(j)
      error('Block sizes must be nondecreasing.')
   end
end

blkloc(1) = 1;
for j = 1:nblks 
   blkloc(j+1) = blkloc(j) + blksz(j);
end
n = blkloc(nblks+1) - 1;

A = randn(n) + sqrt(-1)*randn(n);

for i=1:index
   A(blkloc(i):n, blkloc(i):blkloc(i+1)-1) = 0;
end

A = A/norm(A);

ss = [];
for i=1:index-1
   if nargin == 4 && smin(i) > 0
      [U, S, V] = svd(A(blkloc(i):blkloc(i+1)-1,blkloc(i+1):blkloc(i+2)-1),0);
      j = size(S,1);
      S(j,j) = smin(i);
      s0 = smin(i);
      A(blkloc(i):blkloc(i+1)-1,blkloc(i+1):blkloc(i+2)-1)= U*S*V';
   else
      s = svd(A(blkloc(i):blkloc(i+1)-1,blkloc(i+1):blkloc(i+2)-1));
      j = max(size(s));
      s0 = s(j);
   end
   ss(i) = s0;
end
ss

