function [QQ, RR] = cddqrrow(Q, R)

% Given the QR factorization
%
%   [A(1,:); A(2:n,:)] = [Q(1,:); Q(2:n,:)]*R
%
% this function computes the QR factorization.  
%
%  A(2:m,:) = QQ*RR.
%
% It uses the functions gssro orthogonalize a vector by the
% Gram-Schmidt method with reorthogonalization and grotgen
% and grotapp to handle plane rotations.

[m, n] = size(Q);

if m <= n, error('Too few rows in the decomposition.'), end

x = zeros(m,1);
x(1) = 1;

[y, r, rho] = gssro(Q, x);

u = zeros(1,n);

for k=n:-1:1
   [rho, r(k), G] = grotgen(rho, r(k));
   [u(k:n), R(k,k:n)] = grotapp(G, u(k:n), R(k,k:n), 00);
   [y, Q(:,k)] = grotapp(G, y, Q(:,k), 11);
end


QQ = Q(2:m,:);
RR = R;

