function [v, nrmrv] = aprox_nv(R, tol)

% This function produces an approximate null vector of the upper
% triangular matrix R, using a simplified LINPACK contition
% estimator.  (Note that scaling to avoid overflow is not included.)


% Initialize.


n = size(R,1); v = zeros(n,1); if nargin == 1, tol = 0; end

% Look for the first diagonal element that is zero within the input
% tolerance tol.

for nn = 1:n
   if abs(R(nn,nn)) <= tol, break; end
end 

if abs(R(nn,nn)) <= tol

%  Small element found.  Compute an approximate null vector by solving
%  R(1:nn,1:nn)*v = [0; 1];

   v(nn) = 1;
   for i=nn-1:-1:1
      v(i) = -R(i,i+1:nn)*v(i+1:nn)/R(i,i);
   end
   v = v/norm(v);
   nrmrv = norm(R*v);
else

%  No small element found.  Compute approximate null vector a la
%  LINPACK.


   u = zeros(n,1);
   u(1) = 1/R(1,1);
   for i=2:n
      d = -u(1:i-1)'*R(1:i-1,i);
      if d >=0
        u(i) = (d+1)/R(i,i);
      else
        u(i) = (d-1)/R(i,i);
      end
   end
   u = u/norm(u);
   warning('off', 'all');
   v = R\u;
   warning('on', 'all');
   normv = norm(v);
   v = v/normv;
   nrmrv = 1/normv;
end

