function [aa, bb] = grotapp(G, a, b, job)

% grotapp applies the Givens rotation G to the elements of the 
% vectors a and b and returns the result in aa bb. 
%
% Input:
%
%    G     a Givens plane rotation
%
%    a, b  two vectors of the same dimensions.
%
%    job   a parameter that takes the values 00, 01, 10, OO:
%
%          00  a and b are row vectors, apply G on the left
%          01  a and b are row vectors, apply G' on the left
%          10  a and b are column vectors, apply G on the right
%          11  a and b are column vectors, apply G' on the right


   if job == 00
      ab = G*[a; b];
      aa = ab(1,:);
      bb = ab(2,:);
   elseif job == 01
      ab = G'*[a; b];
      aa = ab(1,:);
      bb = ab(2,:);
   elseif job == 10
      ab = [a, b]*G;
      aa = ab(:,1);
      bb = ab(:,2);
   elseif job == 11
      ab = [a, b]*G';
      aa = ab(:,1);
      bb = ab(:,2);
   else
      error('Illegal job code (should be 00, 01, 10, or 11).')
   end
return
