function njb = numjblocks0(gamma)
% gamma must be computed as the 5th output arg from GNSD for given A and tol
% njb is an additional useful output for GNSD that was not included in the published code
% gamma(k) is the number of Jordan blocks of size >= k associated with the zero eigenvalue of A
% njb(k)   is the number of Jordan blocks of size == k associated with the zero eigenvalue of A
% Michael Overton
njb = -diff([gamma 0]); % see p.2 of GNSD paper (Guglielmi, Overton, Stewart, SIMAX, 2015)