function [A,J,K,T] = test_drazin(jblocksizes,r,complx)
% 
% generate test matrix for Drazin inverse
% input: 
%    jblocksizes: Jordan block sizes for a matrix J with zero eigenvalues
%    r: dimension for a randomly generated block K
%    complx: 1 if complex A is desired, 0 otherwise (default 0)
% output:
%    A = T*diag(J,K)*T^{-1}
%    J = diag(jblock(jblocksizes(1),...,jblocksizes(end))
%    K = randn(r,r)
%    T = randn(dim(J)+r,dim(J)+r)
%
if nargin < 3
    complx = 0;
end
row = 1;
for k=1:length(jblocksizes)
    s = jblocksizes(k);
    J(row:row+s-1,row:row+s-1) = jblock(s);
    row = row + s;
end
K = randn(r,r);
n = sum(jblocksizes) + r;
T = randn(n);
if complx
    K = K + 1i*randn(r,r);
    T = T + 1i*randn(n,n);
end
JK = J;
JK(n-r+1:n,n-r+1:n) = K;
A = T*JK/T;
end
function J = jblock(n);   % generate Jordan block of size n
J = diag(ones(n-1,1),1);
end

    
    