/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.field.BaseDateTimeField;
import org.joda.time.field.BaseDurationField;
import org.joda.time.field.FieldUtils;

public abstract class ImpreciseDateTimeField
extends BaseDateTimeField {
    private static final long serialVersionUID = 7190739608550251860L;
    final long iUnitMillis;
    private final DurationField iDurationField;

    public ImpreciseDateTimeField(DateTimeFieldType type, long unitMillis) {
        super(type);
        this.iUnitMillis = unitMillis;
        this.iDurationField = new LinkedDurationField(type.getDurationType());
    }

    public abstract int get(long var1);

    public abstract long set(long var1, int var3);

    public abstract long add(long var1, int var3);

    public abstract long add(long var1, long var3);

    public int getDifference(long minuendInstant, long subtrahendInstant) {
        return FieldUtils.safeToInt(this.getDifferenceAsLong(minuendInstant, subtrahendInstant));
    }

    public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
        if (minuendInstant < subtrahendInstant) {
            return -this.getDifferenceAsLong(subtrahendInstant, minuendInstant);
        }
        long difference = (minuendInstant - subtrahendInstant) / this.iUnitMillis;
        if (this.add(subtrahendInstant, difference) < minuendInstant) {
            while (this.add(subtrahendInstant, ++difference) <= minuendInstant) {
            }
            --difference;
        } else if (this.add(subtrahendInstant, difference) > minuendInstant) {
            while (this.add(subtrahendInstant, --difference) > minuendInstant) {
            }
        }
        return difference;
    }

    public final DurationField getDurationField() {
        return this.iDurationField;
    }

    public abstract DurationField getRangeDurationField();

    public abstract long roundFloor(long var1);

    protected final long getDurationUnitMillis() {
        return this.iUnitMillis;
    }

    private final class LinkedDurationField
    extends BaseDurationField {
        private static final long serialVersionUID = -203813474600094134L;

        LinkedDurationField(DurationFieldType type) {
            super(type);
        }

        public boolean isPrecise() {
            return false;
        }

        public long getUnitMillis() {
            return ImpreciseDateTimeField.this.iUnitMillis;
        }

        public int getValue(long duration, long instant) {
            return ImpreciseDateTimeField.this.getDifference(instant + duration, instant);
        }

        public long getValueAsLong(long duration, long instant) {
            return ImpreciseDateTimeField.this.getDifferenceAsLong(instant + duration, instant);
        }

        public long getMillis(int value, long instant) {
            return ImpreciseDateTimeField.this.add(instant, value) - instant;
        }

        public long getMillis(long value, long instant) {
            return ImpreciseDateTimeField.this.add(instant, value) - instant;
        }

        public long add(long instant, int value) {
            return ImpreciseDateTimeField.this.add(instant, value);
        }

        public long add(long instant, long value) {
            return ImpreciseDateTimeField.this.add(instant, value);
        }

        public int getDifference(long minuendInstant, long subtrahendInstant) {
            return ImpreciseDateTimeField.this.getDifference(minuendInstant, subtrahendInstant);
        }

        public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
            return ImpreciseDateTimeField.this.getDifferenceAsLong(minuendInstant, subtrahendInstant);
        }
    }
}

