/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import pnuts.lang.BinaryOperator;
import pnuts.lang.Numeric;
import pnuts.lang.Runtime;

public abstract class UnaryOperator
implements Serializable {
    protected Object op_int(int i) {
        throw new IllegalArgumentException(String.valueOf(i));
    }

    protected Object op_long(long l) {
        throw new IllegalArgumentException(String.valueOf(l));
    }

    protected Object op_float(float f) {
        throw new IllegalArgumentException(String.valueOf(f));
    }

    protected Object op_double(double d) {
        throw new IllegalArgumentException(String.valueOf(d));
    }

    protected Object op_bdec(BigDecimal d) {
        throw new IllegalArgumentException(String.valueOf(d));
    }

    protected Object op_bint(BigInteger b) {
        throw new IllegalArgumentException(String.valueOf(b));
    }

    protected Object op_boolean(boolean b) {
        throw new IllegalArgumentException(String.valueOf(b));
    }

    protected Object op_numeric(Numeric b) {
        throw new IllegalArgumentException(String.valueOf(b));
    }

    public Object operateOn(Object n) {
        if (n instanceof Integer) {
            return this.op_int((Integer)n);
        }
        if (n instanceof Character) {
            return this.op_int(((Character)n).charValue());
        }
        if (n instanceof Byte) {
            return this.op_int(((Byte)n).intValue());
        }
        if (n instanceof Short) {
            return this.op_int(((Short)n).intValue());
        }
        if (n instanceof Long) {
            return this.op_long((Long)n);
        }
        if (n instanceof Float) {
            return this.op_float(((Float)n).floatValue());
        }
        if (n instanceof Double) {
            return this.op_double((Double)n);
        }
        if (n instanceof BigDecimal) {
            return this.op_bdec((BigDecimal)n);
        }
        if (n instanceof BigInteger) {
            return this.op_bint((BigInteger)n);
        }
        if (n instanceof Boolean) {
            return this.op_boolean((Boolean)n);
        }
        if (n instanceof Numeric) {
            return this.op_numeric((Numeric)n);
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    public static class Not
    extends UnaryOperator {
        static Not instance = new Not();

        public Object op_int(int n) {
            return new Integer(~n);
        }

        public Object op_long(long n) {
            return new Long(n ^ 0xFFFFFFFFFFFFFFFFL);
        }

        public Object op_bint(BigInteger n) {
            return n.not();
        }
    }

    public static class Negate
    extends UnaryOperator {
        static Negate instance = new Negate();

        public Object op_int(int n) {
            return new Integer(-n);
        }

        public Object op_long(long n) {
            return new Long(-n);
        }

        public Object op_float(float n) {
            return new Float(-n);
        }

        public Object op_double(double n) {
            return new Double(-n);
        }

        public Object op_bdec(BigDecimal n) {
            return n.negate();
        }

        public Object op_bint(BigInteger n) {
            return n.negate();
        }

        public Object op_numeric(Numeric b) {
            return b.negate();
        }
    }

    public static class Subtract1
    extends UnaryOperator {
        static Subtract1 instance = new Subtract1();

        public Object op_int(int i) {
            if (i > 0 && i <= 64) {
                return BinaryOperator.smallInt[i - 1];
            }
            if (i == Integer.MIN_VALUE) {
                return new Long((long)i - 1L);
            }
            return new Integer(i - 1);
        }

        public Object op_long(long i) {
            if (i == Long.MIN_VALUE) {
                return this.op_bint(BigInteger.valueOf(i));
            }
            if (i == 0x80000000L) {
                return new Integer(Integer.MAX_VALUE);
            }
            return new Long(i - 1L);
        }

        public Object op_bint(BigInteger i) {
            return Runtime.compress(i.add(BigInteger.valueOf(-1L)));
        }
    }

    public static class Add1
    extends UnaryOperator {
        static Add1 instance = new Add1();

        public Object op_int(int i) {
            if (i == Integer.MAX_VALUE) {
                return new Long((long)i + 1L);
            }
            return new Integer(i + 1);
        }

        public Object op_long(long i) {
            if (i == Long.MAX_VALUE) {
                return this.op_bint(BigInteger.valueOf(i));
            }
            return new Long(i + 1L);
        }

        public Object op_bint(BigInteger i) {
            return Runtime.compress(i.add(BigInteger.valueOf(1L)));
        }
    }
}

