/*
 * Decompiled with CFR 0.152.
 */
package tratz.runpipe.util;

import java.util.ArrayList;
import java.util.List;
import tratz.runpipe.TextDocument;
import tratz.runpipe.annotations.Sentence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeuristicLongSentenceSplittingUtil {
    public static List<Sentence> splitSentences(TextDocument doc, List<Sentence> sentences) {
        ArrayList<Sentence> newSentences = new ArrayList<Sentence>();
        int textLength = doc.getText().length();
        for (Sentence s : sentences) {
            String sText = s.getAnnotText();
            String[] split = sText.split("([^.?!][^.?!])([.?!;])([^.?!0-9][^.?!0-9])");
            if (split.length > 1) {
                int start = 0;
                for (int i = 0; i < split.length; ++i) {
                    String part = split[i];
                    Sentence newSentence = new Sentence(doc, i == 0 ? s.getStart() : s.getStart() + start - 2, Math.min(textLength, s.getStart() + start + part.length() + 3));
                    newSentence.setSentenceNum(s.getSentenceNum());
                    if (!newSentence.getAnnotText().trim().equals("")) {
                        newSentences.add(newSentence);
                        doc.addAnnotation(newSentence);
                    }
                    start = start + part.length() + 5;
                }
                doc.removeAnnotation(s);
                continue;
            }
            int midSpace = sText.indexOf(" ", sText.length() / 2);
            if (midSpace == -1 || midSpace == sText.length() - 1) {
                midSpace = sText.lastIndexOf(" ", sText.length() / 2);
            }
            if (midSpace <= 1 || midSpace >= sText.length() - 1) continue;
            Sentence newSentence1 = new Sentence(doc, s.getStart(), s.getStart() + midSpace);
            Sentence newSentence2 = new Sentence(doc, s.getStart() + midSpace + 1, s.getEnd());
            newSentence1.setSentenceNum(s.getSentenceNum());
            newSentence2.setSentenceNum(s.getSentenceNum());
            if (!newSentence1.getAnnotText().trim().equals("")) {
                newSentences.add(newSentence1);
                doc.addAnnotation(newSentence1);
            }
            if (!newSentence2.getAnnotText().trim().equals("")) {
                newSentences.add(newSentence2);
                doc.addAnnotation(newSentence2);
            }
            doc.removeAnnotation(s);
        }
        return newSentences;
    }
}

