/*
 * Decompiled with CFR 0.152.
 */
package tratz.runpipe.impl.endpoints;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import tratz.runpipe.Annotation;
import tratz.runpipe.EndPoint;
import tratz.runpipe.InitializationException;
import tratz.runpipe.ProcessException;
import tratz.runpipe.TextDocument;
import tratz.runpipe.annotations.Sentence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainTextSentenceWriter
implements EndPoint,
Serializable {
    private static final long serialVersionUID = 1L;
    private PrintWriter mWriter;
    private String PARAM_OUTPUTFILENAME = "outputFilename";

    @Override
    public void initialize(Map<String, String> args) throws InitializationException {
        try {
            this.mWriter = new PrintWriter(new FileWriter(args.get(this.PARAM_OUTPUTFILENAME)));
        }
        catch (IOException ioe) {
            throw new InitializationException(ioe);
        }
    }

    @Override
    public void process(TextDocument doc) throws ProcessException {
        List<? extends Annotation> sList = doc.getAnnotationList(Sentence.class);
        if (sList != null) {
            for (Sentence sentence : sList) {
                this.mWriter.println(sentence.getAnnotText().replace('\n', ' '));
            }
        }
    }

    @Override
    public void batchFinished() {
        this.mWriter.close();
    }
}

