/*
 * Decompiled with CFR 0.152.
 */
package tratz.runpipe;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import tratz.runpipe.Annotator;
import tratz.runpipe.CorpusReader;
import tratz.runpipe.DocumentReadException;
import tratz.runpipe.EndPoint;
import tratz.runpipe.InitializationException;
import tratz.runpipe.ProcessException;
import tratz.runpipe.TextDocument;
import tratz.runpipe.TextDocumentReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pipe {
    private Map<String, String> mCorpusParams;
    private Map<String, String> mDocParams;
    private Map<Annotator, Map<String, String>> mAnnotatorParams = new HashMap<Annotator, Map<String, String>>();
    private Map<EndPoint, Map<String, String>> mEndUnitParams = new HashMap<EndPoint, Map<String, String>>();
    private CorpusReader mCorpusReader;
    private TextDocumentReader mDocumentReader;
    private List<Annotator> mAnnotators = new LinkedList<Annotator>();
    private List<EndPoint> mEndUnits = new LinkedList<EndPoint>();

    public void go() throws IOException, DocumentReadException, InitializationException, ProcessException {
        if (this.mDocumentReader != null) {
            System.err.println("Initializing document reader");
            this.mDocumentReader.initialize(this.mDocParams);
            this.mCorpusReader.setDocumentReader(this.mDocumentReader);
        }
        System.err.println("Initializing corpus reader");
        this.mCorpusReader.initialize(this.mCorpusParams);
        for (Annotator annotator : this.mAnnotators) {
            System.err.println("Initializing annotator");
            annotator.initialize(this.mAnnotatorParams.get(annotator));
        }
        for (EndPoint unit : this.mEndUnits) {
            System.err.println("Initializing end unit");
            unit.initialize(this.mEndUnitParams.get(unit));
        }
        while (this.mCorpusReader.hasNext()) {
            TextDocument doc = this.mCorpusReader.getNext();
            for (Annotator annotator : this.mAnnotators) {
                annotator.process(doc);
            }
            for (EndPoint unit : this.mEndUnits) {
                unit.process(doc);
            }
        }
        System.err.println("Annotator processing complete");
        for (EndPoint unit : this.mEndUnits) {
            unit.batchFinished();
        }
        System.err.println("End point processing complete");
    }

    public void setCorpusReader(CorpusReader corpusReader, Map<String, String> params) {
        this.mCorpusReader = corpusReader;
        this.mCorpusParams = params;
    }

    public CorpusReader getCorpusReader() {
        return this.mCorpusReader;
    }

    public void setDocumentReader(TextDocumentReader docReader, Map<String, String> params) {
        this.mDocumentReader = docReader;
        this.mDocParams = params;
    }

    public TextDocumentReader getDocumentReader() {
        return this.mDocumentReader;
    }

    public List<Annotator> getAnnotators() {
        return new ArrayList<Annotator>(this.mAnnotators);
    }

    public List<EndPoint> getEndProcessingUnits() {
        return new ArrayList<EndPoint>(this.mEndUnits);
    }

    public void addAnnotator(Annotator annotator, Map<String, String> params) {
        this.mAnnotators.add(annotator);
        this.mAnnotatorParams.put(annotator, params);
    }

    public void removeAnnotator(Annotator annotator) {
        this.mAnnotators.remove(annotator);
        this.mAnnotatorParams.put(annotator, null);
    }

    public void addEndProcessingUnit(EndPoint unit, Map<String, String> params) {
        this.mEndUnits.add(unit);
        this.mEndUnitParams.put(unit, params);
    }

    public void removeEndProcessingUnit(EndPoint unit) {
        this.mEndUnits.remove(unit);
        this.mEndUnitParams.put(unit, null);
    }
}

