/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.dictionary;

import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.data.Exc;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.dictionary.Dictionary;
import net.didion.jwnl.dictionary.MorphologicalProcessor;
import net.didion.jwnl.dictionary.POSKey;
import net.didion.jwnl.dictionary.file.DictionaryFileType;
import net.didion.jwnl.util.cache.Cache;
import net.didion.jwnl.util.cache.CacheSet;
import net.didion.jwnl.util.cache.LRUCache;

public abstract class AbstractCachingDictionary
extends Dictionary {
    private DictionaryCacheSet _caches = null;

    protected AbstractCachingDictionary() {
    }

    protected AbstractCachingDictionary(boolean bl) {
        if (bl) {
            this.createCacheSet();
        }
    }

    protected AbstractCachingDictionary(CacheSizes cacheSizes) {
        this.createCacheSet(cacheSizes);
    }

    protected AbstractCachingDictionary(MorphologicalProcessor morphologicalProcessor) {
        super(morphologicalProcessor);
    }

    protected AbstractCachingDictionary(MorphologicalProcessor morphologicalProcessor, boolean bl) {
        super(morphologicalProcessor);
        if (bl) {
            this.createCacheSet();
        }
    }

    protected AbstractCachingDictionary(MorphologicalProcessor morphologicalProcessor, CacheSizes cacheSizes) {
        super(morphologicalProcessor);
        this.createCacheSet(cacheSizes);
    }

    public void clearCache() {
        int n = 0;
        while (n < DictionaryFileType.FILE_TYPES.length) {
            this.clearCache(DictionaryFileType.FILE_TYPES[n]);
            ++n;
        }
    }

    public void clearCache(DictionaryFileType dictionaryFileType) {
        if (!this.isCachingEnabled()) {
            throw new JWNLRuntimeException("DICTIONARY_EXCEPTION_014");
        }
        this._caches.clearCache(dictionaryFileType);
    }

    private void createCacheSet() {
        this._caches = new DictionaryCacheSet();
    }

    private void createCacheSet(CacheSizes cacheSizes) {
        this._caches = new DictionaryCacheSet(cacheSizes.getSizes());
    }

    public boolean isCachingEnabled() {
        return this._caches != null;
    }

    protected void cacheIndexWord(POSKey pOSKey, IndexWord indexWord) {
        this.cache(DictionaryFileType.INDEX, pOSKey, indexWord);
    }

    protected IndexWord getCachedIndexWord(POSKey pOSKey) {
        return (IndexWord)this.getCached(DictionaryFileType.INDEX, pOSKey);
    }

    protected void cacheSynset(POSKey pOSKey, Synset synset) {
        this.cache(DictionaryFileType.DATA, pOSKey, synset);
    }

    protected Synset getCachedSynset(POSKey pOSKey) {
        return (Synset)this.getCached(DictionaryFileType.DATA, pOSKey);
    }

    protected void cacheException(POSKey pOSKey, Exc exc) {
        this.cache(DictionaryFileType.EXCEPTION, pOSKey, exc);
    }

    protected Exc getCachedException(POSKey pOSKey) {
        return (Exc)this.getCached(DictionaryFileType.EXCEPTION, pOSKey);
    }

    private void cache(DictionaryFileType dictionaryFileType, POSKey pOSKey, Object object) {
        if (!this.isCachingEnabled()) {
            throw new JWNLRuntimeException("DICTIONARY_EXCEPTION_014");
        }
        this._caches.cacheObject(dictionaryFileType, (Object)pOSKey, object);
    }

    private Object getCached(DictionaryFileType dictionaryFileType, POSKey pOSKey) {
        if (this.isCachingEnabled()) {
            return this._caches.getCachedObject(dictionaryFileType, (Object)pOSKey);
        }
        throw new JWNLRuntimeException("DICTIONARY_EXCEPTION_014");
    }

    private static final class DictionaryCacheSet
    extends CacheSet
    implements Observer {
        private Map _lemmaToOffsetMaps;

        public DictionaryCacheSet() {
            super(DictionaryFileType.FILE_TYPES);
            this.initLemmaToOffsetMaps();
        }

        public DictionaryCacheSet(int[] nArray) {
            super((Object[])DictionaryFileType.FILE_TYPES, nArray);
            this.initLemmaToOffsetMaps();
        }

        public Object getCachedObject(DictionaryFileType dictionaryFileType, Object object) {
            if (((POSKey)object).isLemmaKey()) {
                object = this.getMap(dictionaryFileType).get(object);
            }
            return object == null ? null : super.getCachedObject(dictionaryFileType, object);
        }

        public void cacheObject(DictionaryFileType dictionaryFileType, Object object, Object object2) {
            if (object2 instanceof IndexWord) {
                IndexWord indexWord = (IndexWord)object2;
                this.getMap(DictionaryFileType.INDEX).put(new POSKey(indexWord.getPOS(), indexWord.getLemma()), object);
            } else if (object2 instanceof Exc) {
                Exc exc = (Exc)object2;
                this.getMap(DictionaryFileType.EXCEPTION).put(new POSKey(exc.getPOS(), exc.getLemma()), object);
            }
            super.cacheObject(dictionaryFileType, object, object2);
        }

        public void clearCache(DictionaryFileType dictionaryFileType) {
            Map map = this.getMap(dictionaryFileType);
            if (map != null) {
                map.clear();
            }
            super.clearCache(dictionaryFileType);
        }

        public void update(Observable observable, Object object) {
            if (object instanceof IndexWord) {
                IndexWord indexWord = (IndexWord)object;
                this.removeLemma(DictionaryFileType.INDEX, indexWord.getLemma(), indexWord.getPOS());
            } else if (object instanceof Exc) {
                Exc exc = (Exc)object;
                this.removeLemma(DictionaryFileType.EXCEPTION, exc.getLemma(), exc.getPOS());
            }
        }

        private void initLemmaToOffsetMaps() {
            this._lemmaToOffsetMaps = new HashMap(2);
            this._lemmaToOffsetMaps.put(DictionaryFileType.INDEX, new HashMap(this.getCache(DictionaryFileType.INDEX).getCapacity()));
            this._lemmaToOffsetMaps.put(DictionaryFileType.EXCEPTION, new HashMap(this.getCache(DictionaryFileType.EXCEPTION).getCapacity()));
        }

        private void removeLemma(DictionaryFileType dictionaryFileType, String string, POS pOS) {
            ((Map)this._lemmaToOffsetMaps.get(dictionaryFileType)).remove(new POSKey(pOS, string));
        }

        private Map getMap(DictionaryFileType dictionaryFileType) {
            return (Map)this._lemmaToOffsetMaps.get(dictionaryFileType);
        }

        protected Cache createCache(int n) {
            ObservableCache observableCache = new ObservableCache(n);
            observableCache.addObserver(this);
            return observableCache;
        }

        private static final class ObservableCache
        extends LRUCache {
            private Observable _observable = new Observable();

            public ObservableCache(int n) {
                super(n);
            }

            public void addObserver(Observer observer) {
                this._observable.addObserver(observer);
            }

            public Object remove(Object object) {
                Object v = super.remove(object);
                this._observable.notifyObservers(v);
                return v;
            }
        }
    }

    protected static final class CacheSizes {
        private int _indexWordCacheSize;
        private int _synsetCacheSize;
        private int _exceptionCacheSize;

        public CacheSizes() {
            this(1000);
        }

        public CacheSizes(int n) {
            this._indexWordCacheSize = n;
            this._synsetCacheSize = n;
            this._exceptionCacheSize = n;
        }

        public int getIndexWordCacheSize() {
            return this._indexWordCacheSize;
        }

        public int getSynsetCacheSize() {
            return this._synsetCacheSize;
        }

        public int getExceptionCacheSize() {
            return this._exceptionCacheSize;
        }

        public int[] getSizes() {
            return new int[]{this._indexWordCacheSize, this._synsetCacheSize, this._exceptionCacheSize};
        }

        public void setIndexWordCacheSize(int n) {
            this._indexWordCacheSize = n;
        }

        public void setSynsetCacheSize(int n) {
            this._synsetCacheSize = n;
        }

        public void setExceptionCacheSize(int n) {
            this._exceptionCacheSize = n;
        }
    }
}

