/*
 * Decompiled with CFR 0.152.
 */
package org.ho.yaml;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.ho.util.Logger;
import org.ho.yaml.JYamlParserEvent;
import org.ho.yaml.YamlConfig;
import org.ho.yaml.YamlStream;
import org.ho.yaml.exception.YamlException;
import yaml.parser.SyntaxException;
import yaml.parser.YamlParser;
import yaml.parser.YamlParserEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlDecoder {
    BufferedReader in;
    YamlParser parser;
    YamlConfig config = YamlConfig.getDefaultConfig();

    YamlDecoder(InputStream inputStream, YamlConfig yamlConfig) {
        this.config = yamlConfig;
        try {
            this.in = new BufferedReader(new InputStreamReader(inputStream, yamlConfig.encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public YamlDecoder(InputStream inputStream) {
        try {
            this.in = new BufferedReader(new InputStreamReader(inputStream, this.config.encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public YamlDecoder(Reader reader) {
        this.in = new BufferedReader(reader);
    }

    public YamlDecoder(Reader reader, YamlConfig yamlConfig) {
        this(reader);
        this.config = yamlConfig;
    }

    public Object readObject() throws EOFException {
        try {
            JYamlParserEvent jYamlParserEvent = new JYamlParserEvent(this.createLogger(), this);
            if (this.parser == null) {
                this.parser = new YamlParser(this.in, jYamlParserEvent);
                this.firstDocument(this.parser, jYamlParserEvent);
            } else {
                this.parser.setEvent(jYamlParserEvent);
                if (!this.nextDocument(this.parser, jYamlParserEvent)) {
                    throw new EOFException();
                }
            }
            Object object = jYamlParserEvent.getBean();
            if (object == null) {
                throw new YamlException("Document is empty.");
            }
            return object;
        }
        catch (EOFException eOFException) {
            throw eOFException;
        }
        catch (YamlException yamlException) {
            throw yamlException;
        }
    }

    public <T> YamlStream asStreamOfType(Class<T> clazz) {
        return new Stream<T>(clazz);
    }

    public YamlStream asStream() {
        return new Stream<Object>(Object.class);
    }

    Logger createLogger() {
        if (this.isSuppressWarnings()) {
            return new Logger(Logger.Level.NONE);
        }
        return new Logger();
    }

    void firstDocument(YamlParser yamlParser, YamlParserEvent yamlParserEvent) {
        try {
            while (yamlParser.comment(-1, false)) {
            }
            if (!yamlParser.header()) {
                yamlParser.document_first();
            } else {
                yamlParser.value_na(-1);
            }
        }
        catch (SyntaxException syntaxException) {
            yamlParserEvent.error(syntaxException, syntaxException.line);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    boolean nextDocument(YamlParser yamlParser, YamlParserEvent yamlParserEvent) {
        try {
            return yamlParser.document_next();
        }
        catch (SyntaxException syntaxException) {
            yamlParserEvent.error(syntaxException, syntaxException.line);
            return false;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public <T> T readObjectOfType(Class<T> clazz) throws EOFException {
        try {
            JYamlParserEvent jYamlParserEvent = new JYamlParserEvent(clazz, this.createLogger(), this);
            if (this.parser == null) {
                this.parser = new YamlParser(this.in, jYamlParserEvent);
                this.firstDocument(this.parser, jYamlParserEvent);
            } else {
                this.parser.setEvent(jYamlParserEvent);
                if (!this.nextDocument(this.parser, jYamlParserEvent)) {
                    throw new EOFException();
                }
            }
            Object object = jYamlParserEvent.getBean();
            if (object == null) {
                throw new YamlException("Document is empty.");
            }
            return (T)object;
        }
        catch (EOFException eOFException) {
            throw eOFException;
        }
        catch (Exception exception) {
            throw new YamlException(exception);
        }
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isSuppressWarnings() {
        return this.config.isSuppressWarnings();
    }

    public void setSuppressWarnings(boolean bl) {
        this.config.setSuppressWarnings(bl);
    }

    public YamlConfig getConfig() {
        return this.config;
    }

    public void setConfig(YamlConfig yamlConfig) {
        this.config = yamlConfig;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Stream<T>
    implements YamlStream<T> {
        Class<T> clazz;
        T buffer;

        Stream(Class<T> clazz) {
            this.clazz = clazz;
            this.peek();
        }

        private void peek() {
            try {
                this.buffer = this.clazz == Object.class ? YamlDecoder.this.readObject() : YamlDecoder.this.readObjectOfType(this.clazz);
            }
            catch (EOFException eOFException) {
                YamlDecoder.this.close();
                this.buffer = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.buffer != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T t = this.buffer;
            this.peek();
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported.");
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }
}

