/*
 * Decompiled with CFR 0.152.
 */
package tratz.semantics.srl;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import tratz.cmdline.CommandLineOptions;
import tratz.cmdline.CommandLineOptionsParser;
import tratz.cmdline.ParsedCommandLine;

public class CreateModelsForUnrepresentedPredicates {
    public static final String OPT_PROPBANK_FRAMES_DIR = "propbankframes";
    public static final String OPT_TRAINING_FEATURES_DIR = "instances";

    private static CommandLineOptions createOptions() {
        CommandLineOptions cmdOpts = new CommandLineOptions();
        cmdOpts.addOption(OPT_PROPBANK_FRAMES_DIR, "file", "directory containing the PropBank frame files");
        cmdOpts.addOption(OPT_TRAINING_FEATURES_DIR, "file", "directory containing the training instance files");
        return cmdOpts;
    }

    public static void main(String[] args) throws Exception {
        ParsedCommandLine cmdLine = new CommandLineOptionsParser().parseOptions(CreateModelsForUnrepresentedPredicates.createOptions(), args);
        File propbankFramesDir = new File(cmdLine.getStringValue(OPT_PROPBANK_FRAMES_DIR));
        File trainingFeaturesFilesDir = new File(cmdLine.getStringValue(OPT_TRAINING_FEATURES_DIR));
        HashSet<String> predicatesSet = new HashSet<String>();
        for (File file : propbankFramesDir.listFiles()) {
            if (!file.getName().endsWith(".xml")) continue;
            predicatesSet.add(file.getName().substring(0, file.getName().indexOf(".")));
        }
        HashSet<String> representedPredicatesSet = new HashSet<String>();
        for (File file : trainingFeaturesFilesDir.listFiles()) {
            representedPredicatesSet.add(file.getName());
        }
        predicatesSet.removeAll(representedPredicatesSet);
        for (String predicate : predicatesSet) {
            PrintWriter writer = new PrintWriter(new FileWriter(new File(trainingFeaturesFilesDir, predicate)));
            writer.println("0\u0018" + predicate + ".01\u0018blank");
            writer.close();
        }
    }
}

