/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse.train;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import tratz.cmdline.CommandLineOptions;
import tratz.cmdline.CommandLineOptionsParser;
import tratz.cmdline.ParsedCommandLine;
import tratz.parse.featgen.ParseFeatureGenerator;
import tratz.parse.ml.FinalizedParseModel;
import tratz.parse.ml.TrainablePerceptron;

public class FinalizeParseModel {
    public static final String OPT_INPUT_FILE = "infile";
    public static final String OPT_OUTPUT_FILE = "outfile";
    public static final String OPT_PERCENTAGE_TO_KEEP = "keeppercent";
    public static final double DEFAULT_PERCENTAGE_TO_KEEP = 1.0;

    private static CommandLineOptions createOptions() {
        CommandLineOptions cmdOptions = new CommandLineOptions();
        cmdOptions.addOption(OPT_INPUT_FILE, "file", "input model file");
        cmdOptions.addOption(OPT_OUTPUT_FILE, "file", "output model file (gzipped file)");
        cmdOptions.addOption(OPT_PERCENTAGE_TO_KEEP, "double", "percentage of nonzero features to keep (1.0 = 100%)");
        return cmdOptions;
    }

    public static void main(String[] args) throws Exception {
        ParsedCommandLine cmdLine = new CommandLineOptionsParser().parseOptions(FinalizeParseModel.createOptions(), args);
        File inputModel = new File(cmdLine.getStringValue(OPT_INPUT_FILE));
        File outputModel = new File(cmdLine.getStringValue(OPT_OUTPUT_FILE));
        double percentageToKeep = cmdLine.getDoubleValue(OPT_PERCENTAGE_TO_KEEP, 1.0);
        assert (percentageToKeep > 0.0 && percentageToKeep <= 1.0);
        System.err.print("Loading old model...");
        ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(inputModel), 1000000)));
        TrainablePerceptron sap = (TrainablePerceptron)ois.readObject();
        ParseFeatureGenerator efg = (ParseFeatureGenerator)ois.readObject();
        ois.close();
        System.err.println("Done");
        System.err.print("Creating finalized model...");
        FinalizedParseModel fsap = sap.createFinal(percentageToKeep);
        System.err.println("Done");
        sap = null;
        System.gc();
        System.err.print("Writing finalized model...");
        ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(outputModel), 1000000)));
        oos.writeObject(fsap);
        oos.writeObject(efg);
        oos.close();
        System.err.println("Done");
    }
}

