/*
 * Decompiled with CFR 0.152.
 */
package tratz.ml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import tratz.ml.ClassDictionary;
import tratz.ml.FeatureDictionary;
import tratz.ml.LinearClassificationModel;

public class LiblinearModelReader {
    public static LinearClassificationModel readLiblinearModel(String svmModelFile, String alphabetFile) throws Exception {
        int i;
        Object decisionModel = null;
        FilterInputStream is = new BufferedInputStream(new FileInputStream(alphabetFile), 1000000);
        if (alphabetFile.endsWith(".gz")) {
            is = new GZIPInputStream(is);
        }
        ObjectInputStream ois = new ObjectInputStream(is);
        FeatureDictionary featureDictionary = (FeatureDictionary)ois.readObject();
        ClassDictionary classDictionary = (ClassDictionary)ois.readObject();
        ois.close();
        System.err.println("Loading: " + svmModelFile);
        FilterInputStream fis = new BufferedInputStream(new FileInputStream(new File(svmModelFile)));
        if (svmModelFile.endsWith(".gz")) {
            fis = new GZIPInputStream(fis);
        }
        Pattern whitespaceSplitter = Pattern.compile("\\s+");
        BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
        String line = null;
        String solverType = reader.readLine();
        String numberOfClasses = reader.readLine();
        String labelList = reader.readLine();
        String numberOfFeatures = reader.readLine();
        String biasLine = reader.readLine();
        String wLine = reader.readLine();
        int numFeats = Integer.parseInt(whitespaceSplitter.split(numberOfFeatures)[1]);
        int numLabels = Integer.parseInt(whitespaceSplitter.split(numberOfClasses)[1]);
        int[] labelOrder = new int[numLabels];
        String[] labels = whitespaceSplitter.split(labelList);
        for (int i2 = 1; i2 < labels.length; ++i2) {
            labelOrder[i2 - 1] = Integer.parseInt(labels[i2]);
        }
        ArrayList<float[]> weights = new ArrayList<float[]>(numLabels);
        for (i = 0; i < numLabels; ++i) {
            weights.add(new float[numFeats]);
        }
        for (i = 0; i < numFeats; ++i) {
            line = reader.readLine();
            String[] parts = line.split("\\s+");
            if (parts.length != numLabels) {
                if (parts.length == 1 && numLabels == 2) {
                    float val;
                    float[] vector = weights.get(0);
                    vector[i] = val = (float)Double.parseDouble(parts[0]);
                    float[] vector2 = weights.get(1);
                    vector2[i] = -val;
                    continue;
                }
                throw new Exception("Number of entries (" + parts.length + ") != number of expected labels (" + numLabels + ")");
            }
            for (int j = 0; j < numLabels; ++j) {
                float[] vector = weights.get(j);
                if (parts[j].equals("0")) continue;
                vector[i] = (float)Double.parseDouble(parts[j]);
            }
        }
        reader.close();
        ((InputStream)fis).close();
        return new LinearClassificationModel(weights, labelOrder, classDictionary, featureDictionary);
    }
}

