/*
 * Decompiled with CFR 0.152.
 */
package tratz.ml;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ClassDictionary
implements Serializable {
    public static final long serialVersionUID = 1L;
    private Map<String, Integer> mDict = new HashMap<String, Integer>();
    private Map<Integer, String> mReverse = new HashMap<Integer, String>();
    private int maxIndex;

    public ClassDictionary() {
    }

    public ClassDictionary(ClassDictionary original) {
        this.mDict = original.mDict;
        this.mReverse = original.mReverse;
        this.maxIndex = original.maxIndex;
    }

    public void override(String key, int index) {
        this.mDict.put(key, index);
        this.mReverse.put(index, key);
        if (index > this.maxIndex) {
            this.maxIndex = index;
        }
    }

    public String lookupLabel(int index) {
        return this.mReverse.get(index);
    }

    public int lookupIndex(String key, boolean add) {
        int result = -1;
        Integer index = this.mDict.get(key);
        if (index == null) {
            if (add) {
                ++this.maxIndex;
                this.mDict.put(key, this.maxIndex);
                this.mReverse.put(this.maxIndex, key);
                result = this.maxIndex;
            }
        } else {
            result = index;
        }
        return result;
    }

    public int size() {
        return this.mDict.size();
    }
}

