/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import tratz.cmdline.CommandLineOptions;
import tratz.cmdline.CommandLineOptionsParser;
import tratz.cmdline.ParsedCommandLine;
import tratz.parse.io.ConllxSentenceReader;
import tratz.parse.types.Arc;
import tratz.parse.types.Parse;
import tratz.parse.types.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseScorer {
    public static final String PUNCTUATION_REGEX = "\\(|\\)|:|;|,|\\.|''|``|/";
    public static final String OPT_TRUTH_FILE = "g";
    public static final String OPT_SYSTEM_FILE = "s";
    public static final String OPT_PUNCTUATION = "p";

    private static void tagNonProjectiveArcs(Arc arc, List[] tokenToChildren, Set<Arc> visited, Set<Arc> nonProjective, String ignoreString) {
        Token arcChild;
        List children;
        if (!arc.getChild().getPos().matches(ignoreString)) {
            int childIndex = arc.getChild().getIndex();
            int headIndex = arc.getHead().getIndex();
            for (Arc prevArc : visited) {
                int prevChildIndex = prevArc.getChild().getIndex();
                int prevHeadIndex = prevArc.getHead().getIndex();
                if ((childIndex <= prevChildIndex || childIndex >= prevHeadIndex) && (childIndex >= prevChildIndex || childIndex <= prevHeadIndex) || (headIndex <= prevChildIndex || headIndex <= prevHeadIndex) && (headIndex >= prevChildIndex || headIndex >= prevHeadIndex)) continue;
                nonProjective.add(arc);
                break;
            }
            visited.add(arc);
        }
        if ((children = tokenToChildren[(arcChild = arc.getChild()).getIndex()]) != null) {
            Collections.sort(children, new Comparator<Arc>(){

                @Override
                public int compare(Arc a1, Arc a2) {
                    int diff1 = Math.abs(a1.getChild().getIndex() - arcChild.getIndex());
                    int diff2 = Math.abs(a2.getChild().getIndex() - arcChild.getIndex());
                    return diff1 - diff2;
                }
            });
            for (Arc child : children) {
                ParseScorer.tagNonProjectiveArcs(child, tokenToChildren, visited, nonProjective, ignoreString);
            }
        }
    }

    public static LASresults calc(int numTokens, Parse goldParse, Parse predictedParse, String ignoreString) {
        LASresults results = new LASresults();
        Arc[] goldTokenToHead = goldParse.getHeadArcs();
        List[] goldTokenToChildren = goldParse.getDependentArcLists();
        Arc[] predictedTokenToHead = predictedParse.getHeadArcs();
        Arc rootArc = null;
        for (int i = 1; i < goldTokenToHead.length; ++i) {
            if (goldTokenToHead[i].getHead().getIndex() != 0) continue;
            rootArc = goldTokenToHead[i];
        }
        HashSet<Arc> visited = new HashSet<Arc>();
        HashSet<Arc> nonProjective = new HashSet<Arc>();
        ParseScorer.tagNonProjectiveArcs(rootArc, goldTokenToChildren, visited, nonProjective, ignoreString);
        for (int i = 1; i < goldTokenToHead.length; ++i) {
            boolean match2;
            Arc predicted = predictedTokenToHead[i];
            Arc gold = goldTokenToHead[i];
            boolean match1 = gold.getChild().getPos().matches(ignoreString);
            if (match1 != (match2 = gold.getChild().getPos().matches(PUNCTUATION_REGEX))) {
                System.err.println(gold.getChild() + " " + gold.getChild().getPos());
            }
            if (gold.getChild().getPos().matches(ignoreString)) continue;
            boolean isNonProjective = nonProjective.contains(goldTokenToHead[i]);
            if (isNonProjective) {
                ++results.numNonProjective;
            }
            if (predicted.getHead().getIndex() == gold.getHead().getIndex()) {
                ++results.numCorrectArcsUnlabeled;
                if (isNonProjective) {
                    ++results.numNonProjectiveCorrectArcsUnlabeled;
                }
                if (predicted.getHead().getIndex() == 0) {
                    results.rootCorrect = true;
                }
                if (predicted.getDependency().equals(gold.getDependency())) {
                    ++results.numCorrectArcsLabeled;
                    if (!isNonProjective) continue;
                    ++results.numNonProjectiveCorrectArcsLabeled;
                    continue;
                }
                if (predicted.getHead().getIndex() == 0) {
                    System.err.println("Diff: " + predicted.getDependency() + " vs " + gold.getDependency());
                }
                ++results.numIncorrectArcsLabeled;
                if (!isNonProjective) continue;
                ++results.numNonProjectiveIncorrectArcsLabeled;
                continue;
            }
            ++results.numIncorrectArcsUnlabeled;
            ++results.numIncorrectArcsLabeled;
            if (!isNonProjective) continue;
            ++results.numNonProjectiveIncorrectArcsLabeled;
            ++results.numNonProjectiveIncorrectArcsUnlabeled;
        }
        return results;
    }

    private static CommandLineOptions createOptions() {
        CommandLineOptions cmdOpts = new CommandLineOptions();
        cmdOpts.addOption(OPT_TRUTH_FILE, "file", "the gold parse file");
        cmdOpts.addOption(OPT_SYSTEM_FILE, "file", "the system predictions file");
        cmdOpts.addOption(OPT_PUNCTUATION, "boolean", "indicator if punctuation should be considered");
        return cmdOpts;
    }

    public static void main(String[] args) throws Exception {
        ParsedCommandLine cmdLine = new CommandLineOptionsParser().parseOptions(ParseScorer.createOptions(), args);
        String truthFile = cmdLine.getStringValue(OPT_TRUTH_FILE);
        String inputFile = cmdLine.getStringValue(OPT_SYSTEM_FILE);
        boolean punct = cmdLine.getBooleanValue(OPT_PUNCTUATION, false);
        ConllxSentenceReader sentenceReader = new ConllxSentenceReader();
        BufferedReader truthreader = new BufferedReader(new FileReader(truthFile));
        BufferedReader testreader = new BufferedReader(new FileReader(inputFile));
        int totalLCorrect = 0;
        int totalUCorrect = 0;
        int totalLWrong = 0;
        int totalUWrong = 0;
        int totalLCorrectNP = 0;
        int totalUCorrectNP = 0;
        int totalLWrongNP = 0;
        int totalUWrongNP = 0;
        int totalLExact = 0;
        int totalUExact = 0;
        int totalSentences = 0;
        int numSentencesWithNonProjective = 0;
        double totalNonProjective = 0.0;
        int rootCorrect = 0;
        Parse truthparse = null;
        while ((truthparse = sentenceReader.readSentence(truthreader)) != null) {
            ++totalSentences;
            Parse testparse = sentenceReader.readSentence(testreader);
            LASresults results = ParseScorer.calc(truthparse.getSentence().getTokens().size(), truthparse, testparse, punct ? "" : PUNCTUATION_REGEX);
            totalLCorrect += results.numCorrectArcsLabeled;
            totalUCorrect += results.numCorrectArcsUnlabeled;
            totalLWrong += results.numIncorrectArcsLabeled;
            totalUWrong += results.numIncorrectArcsUnlabeled;
            totalLCorrectNP += results.numNonProjectiveCorrectArcsLabeled;
            totalUCorrectNP += results.numNonProjectiveCorrectArcsUnlabeled;
            totalLWrongNP += results.numNonProjectiveIncorrectArcsLabeled;
            totalUWrongNP += results.numNonProjectiveIncorrectArcsUnlabeled;
            totalNonProjective += (double)results.numNonProjective;
            if (results.numNonProjective > 0) {
                ++numSentencesWithNonProjective;
            }
            if (results.numIncorrectArcsLabeled == 0) {
                ++totalLExact;
            }
            if (results.numIncorrectArcsUnlabeled == 0) {
                ++totalUExact;
            }
            if (!results.rootCorrect) continue;
            ++rootCorrect;
        }
        truthreader.close();
        testreader.close();
        double total = totalLCorrect + totalLWrong;
        System.err.println("Input File: " + inputFile);
        System.err.println("Truth File: " + truthFile);
        System.err.println("Total arcs evaluated: " + total);
        System.err.println("Total non-projective arcs: " + totalNonProjective);
        System.err.println("Total sentences: " + totalSentences);
        System.err.println("Total non-projective sentences: " + numSentencesWithNonProjective);
        System.err.println("Non-projective arc proportion: " + totalNonProjective / total);
        System.err.println("Non-projective sentence proportion: " + (double)numSentencesWithNonProjective / (double)totalSentences);
        System.err.println("Accuracy (labeled): " + (double)totalLCorrect / total);
        System.err.println("Accuracy (unlabeled): " + (double)totalUCorrect / total);
        System.err.println("Accuracy (labeled) non-projective: " + (double)totalLCorrectNP / totalNonProjective);
        System.err.println("Accuracy (unlabeled) non-projective: " + (double)totalUCorrectNP / totalNonProjective);
        System.err.println("Root accuracy: " + (double)rootCorrect / (double)totalSentences);
        System.err.println("Full sentence match (labeled): " + totalLExact + " " + totalSentences + " " + (double)totalLExact / (double)totalSentences);
        System.err.println("Full sentence match (unlabeled): " + totalUExact + " " + totalSentences + " " + (double)totalUExact / (double)totalSentences);
        System.err.println(totalUCorrect + " " + totalUWrong + " " + (totalUCorrect + totalUWrong));
    }

    public static class LASresults {
        public int numCorrectArcsLabeled;
        public int numIncorrectArcsLabeled;
        public int numCorrectArcsUnlabeled;
        public int numIncorrectArcsUnlabeled;
        public int numNonProjectiveCorrectArcsLabeled;
        public int numNonProjectiveIncorrectArcsLabeled;
        public int numNonProjectiveCorrectArcsUnlabeled;
        public int numNonProjectiveIncorrectArcsUnlabeled;
        public int numNonProjective;
        public boolean rootCorrect;
    }
}

