/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse.ml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tratz.parse.ml.AbstractParseModel;
import tratz.parse.ml.TrainablePerceptron;
import tratz.types.ByteArrayList;
import tratz.types.ChecksumMap;
import tratz.types.IntArrayList;
import tratz.types.ShortArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FinalizedParseModel
extends AbstractParseModel {
    private static final long serialVersionUID = 1L;
    private byte[] mSparseClasses;
    private short[] mSparseEntries;
    private short[] mDenseEntries;
    private int mNumActions;
    private ChecksumMap<String> mFeatToInd;

    public FinalizedParseModel(List<String> actions, Map<String, Integer> actionToIndex, Map<String, Map<String, List<String>>> posPosActs, ChecksumMap<String> featToInd, int count, ArrayList<TrainablePerceptron.Entry> originalEntries, double sizeToKeep) {
        int numActions;
        this.mActions = actions;
        this.mActionToIndex = actionToIndex;
        this.mPosPosActs = posPosActs;
        this.mNumActions = numActions = actionToIndex.size() + 1;
        double maxAbs = 0.0;
        for (TrainablePerceptron.Entry entry : originalEntries) {
            if (entry.w == null) continue;
            int length = entry.w.size();
            for (int i = 0; i < length; ++i) {
                double w = entry.w.get(i);
                double w2 = entry.w2.get(i);
                int c = entry.c.get(i);
                double score = (w2 + w * (double)(count - c)) / (double)count;
                maxAbs = Math.max(maxAbs, Math.abs(score));
            }
        }
        Map<ChecksumMap.TwoPartKey, Integer> keyToIndexMap = featToInd.getKeyToIndexMap();
        int maxIndex = 0;
        for (Integer val : keyToIndexMap.values()) {
            maxIndex = Math.max(val, maxIndex);
        }
        System.err.println("Max index: " + maxIndex + " Number of keys: " + keyToIndexMap.size());
        System.err.println("Number of entries: " + originalEntries.size());
        ArrayList<ChecksumMap.TwoPartKey> keptKeys = new ArrayList<ChecksumMap.TwoPartKey>();
        final HashMap<ChecksumMap.TwoPartKey, Double> keyToScoreMap = new HashMap<ChecksumMap.TwoPartKey, Double>();
        for (ChecksumMap.TwoPartKey key : keyToIndexMap.keySet()) {
            int index = keyToIndexMap.get(key);
            double score = 0.0;
            if (index < originalEntries.size()) {
                TrainablePerceptron.Entry entry = originalEntries.get(index);
                if (entry.w != null) {
                    int length = entry.w.size();
                    for (int i = 0; i < length; ++i) {
                        double val = (double)((entry.w2.get(i) + entry.w.get(i) * (float)(count - entry.c.get(i))) / (float)count) / maxAbs;
                        score += Math.abs(val);
                    }
                }
            }
            keyToScoreMap.put(key, score);
            if (score == 0.0) continue;
            keptKeys.add(key);
        }
        System.err.println("Number of features where sum(abs(feature_weights)) > 0.0: " + keptKeys.size() + " out of " + keyToIndexMap.size());
        List<Object> keys = new ArrayList(keyToScoreMap.keySet());
        Collections.sort(keys, new Comparator<ChecksumMap.TwoPartKey>(){

            @Override
            public int compare(ChecksumMap.TwoPartKey one, ChecksumMap.TwoPartKey two) {
                double score1 = (Double)keyToScoreMap.get(one);
                double score2 = (Double)keyToScoreMap.get(two);
                if (score2 > score1) {
                    return 1;
                }
                if (score2 < score1) {
                    return -1;
                }
                if (one.hash - two.hash != 0) {
                    return one.hash - two.hash;
                }
                return one.checksum - two.checksum;
            }
        });
        int numKeysToKeep = (int)((double)keptKeys.size() * sizeToKeep);
        numKeysToKeep = Math.min(numKeysToKeep, keptKeys.size());
        System.err.println("Keeping " + numKeysToKeep + " keys");
        keys = keys.subList(0, numKeysToKeep);
        ChecksumMap newFeatToInd = new ChecksumMap();
        System.err.println("Max sum(abs(feature_weights)): " + maxAbs);
        int numEntries = keys.size();
        ByteArrayList sparseClasses = new ByteArrayList(numEntries / 3);
        ShortArrayList sparseEntries = new ShortArrayList(numEntries / 3);
        ShortArrayList denseEntries = new ShortArrayList(numEntries * 20);
        int sparseIndex = 1;
        int denseIndex = 0;
        System.err.println("Creating new entries");
        for (int e = 0; e < numEntries; ++e) {
            int index;
            ChecksumMap.TwoPartKey key = (ChecksumMap.TwoPartKey)keys.get(e);
            int oldIndex = keyToIndexMap.get(key);
            if (oldIndex >= originalEntries.size()) continue;
            TrainablePerceptron.Entry entry = originalEntries.get(oldIndex);
            originalEntries.set(oldIndex, null);
            if (entry.w == null) continue;
            if (entry.w.size() == 1) {
                if (entry.classOne > 127) {
                    System.err.println("DANGER: max byte value exceeded for action index");
                }
                double scaledValue = (double)((entry.w2.get(0) + entry.w.get(0) * (float)(count - entry.c.get(0))) / (float)count) / maxAbs * 32667.0;
                sparseClasses.add((byte)entry.classOne);
                sparseEntries.add((short)scaledValue);
                index = -sparseIndex;
                ++sparseIndex;
            } else {
                index = denseIndex++;
                int baseIndex = index * numActions;
                int width = entry.w.size();
                if (width > numActions) {
                    System.err.println("DANGER: more weight entries for feat than there are actions! " + width + " vs " + numActions);
                }
                for (int i = 0; i < width; ++i) {
                    double scaledValue = (double)((entry.w2.get(i) + entry.w.get(i) * (float)(count - entry.c.get(i))) / (float)count) / maxAbs * 32667.0;
                    if (Math.abs(scaledValue) > 32767.0) {
                        System.err.println("DANGER: max short value exceeded for feature weight: " + scaledValue + " " + Short.MAX_VALUE + " " + Short.MIN_VALUE);
                    }
                    for (int j = denseEntries.size(); j < baseIndex + i; ++j) {
                        denseEntries.add((short)0);
                    }
                    denseEntries.add((short)scaledValue);
                }
            }
            newFeatToInd.put(key.hash, key.checksum, index);
        }
        int padding = denseEntries.size() % this.mNumActions;
        for (int i = 0; i < padding; ++i) {
            denseEntries.add((short)0);
        }
        this.mFeatToInd = newFeatToInd;
        this.mDenseEntries = denseEntries.toCompactArray();
        denseEntries = null;
        this.mSparseEntries = sparseEntries.toCompactArray();
        sparseEntries = null;
        this.mSparseClasses = sparseClasses.toCompactArray();
    }

    @Override
    public int getIndex(String feat, boolean add) {
        return this.mFeatToInd.get(feat);
    }

    @Override
    public void score(List<String> actions, IntArrayList feats, int[] indices, double[] scores) {
        int i;
        int numActions = actions.size();
        int numFeats = feats.size();
        for (i = 0; i < numActions; ++i) {
            Integer val = (Integer)this.mActionToIndex.get(actions.get(i));
            indices[i] = val == null ? -1 : val;
            scores[i] = 0.0;
        }
        block1: for (i = 0; i < numFeats; ++i) {
            int feat = feats.get(i);
            if (feat >= 0) {
                for (int a = 0; a < numActions; ++a) {
                    int index;
                    int actionIndex = indices[a];
                    if (actionIndex == -1 || (index = feat * this.mNumActions + actionIndex) >= this.mDenseEntries.length) continue;
                    int n = a;
                    scores[n] = scores[n] + (double)this.mDenseEntries[index];
                }
                continue;
            }
            feat = -feat - 1;
            byte sparseClass = this.mSparseClasses[feat];
            for (int a = 0; a < numActions; ++a) {
                if (indices[a] != sparseClass) continue;
                int n = a;
                scores[n] = scores[n] + (double)this.mSparseEntries[feat];
                continue block1;
            }
        }
    }

    @Override
    public void scoreIntermediate(List<String> action, IntArrayList feats, int[] actionIndices, double[] scores) {
    }
}

