/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.types;

import edu.umass.cs.mallet.base.types.ConstantMatrix;
import edu.umass.cs.mallet.base.types.Matrix;
import edu.umass.cs.mallet.base.types.Matrixn;
import edu.umass.cs.mallet.base.types.SparseVector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SparseMatrixn
implements Matrix,
Cloneable,
Serializable {
    private SparseVector values;
    private int numDimensions;
    private int[] sizes;
    private int singleSize;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public SparseMatrixn(double[] vals) {
        this.numDimensions = 1;
        this.sizes = new int[1];
        this.sizes[0] = vals.length;
        this.values = new SparseVector(vals);
        this.computeSingleSIze();
    }

    public SparseMatrixn(int[] szs) {
        this.numDimensions = szs.length;
        this.sizes = (int[])szs.clone();
        int total = 1;
        int j = 0;
        while (j < this.numDimensions) {
            total *= this.sizes[j];
            ++j;
        }
        this.values = new SparseVector(new double[total]);
        this.computeSingleSIze();
    }

    public SparseMatrixn(int[] szs, double[] vals) {
        this.numDimensions = szs.length;
        this.sizes = (int[])szs.clone();
        this.values = new SparseVector(vals);
        this.computeSingleSIze();
    }

    public SparseMatrixn(int[] szs, int[] idxs, double[] vals) {
        this.numDimensions = szs.length;
        this.sizes = (int[])szs.clone();
        this.values = new SparseVector(idxs, vals, true, true);
        this.computeSingleSIze();
    }

    private void computeSingleSIze() {
        int product = 1;
        int i = 0;
        while (i < this.sizes.length) {
            int size = this.sizes[i];
            product *= size;
            ++i;
        }
        this.singleSize = product;
    }

    public int getNumDimensions() {
        return this.numDimensions;
    }

    public int getDimensions(int[] szs) {
        int i = 0;
        while (i < this.numDimensions) {
            szs[i] = this.sizes[i];
            ++i;
        }
        return this.numDimensions;
    }

    public double value(int[] indices) {
        return this.values.value(this.singleIndex(indices));
    }

    public void setValue(int[] indices, double value) {
        this.values.setValue(this.singleIndex(indices), value);
    }

    public int[] getIndices() {
        return this.values.getIndices();
    }

    public ConstantMatrix cloneMatrix() {
        return new SparseMatrixn(this.sizes, this.values.getIndices(), this.values.getValues());
    }

    public Object clone() {
        return this.cloneMatrix();
    }

    public int singleIndex(int[] indices) {
        return Matrixn.singleIndex(this.sizes, indices);
    }

    public static int singleIndex(int[] szs, int[] indices) {
        int idx = 0;
        int dim = 0;
        while (dim < indices.length) {
            idx = idx * szs[dim] + indices[dim];
            ++dim;
        }
        return idx;
    }

    public void singleToIndices(int single, int[] indices) {
        Matrixn.singleToIndices(single, indices, this.sizes);
    }

    public boolean equals(Object o) {
        if (o instanceof SparseMatrixn) {
            SparseMatrixn m2 = (SparseMatrixn)o;
            return this.numDimensions == m2.numDimensions && this.sizes.equals(m2.sizes) && this.values.equals(m2.values);
        }
        return false;
    }

    public double[] toArray() {
        return this.values.getValues();
    }

    public double singleValue(int i) {
        return this.values.singleValue(i);
    }

    public int singleSize() {
        return this.singleSize;
    }

    public int numLocations() {
        return this.values.numLocations();
    }

    public int location(int index) {
        return this.values.location(index);
    }

    public double valueAtLocation(int location) {
        return this.values.valueAtLocation(location);
    }

    public void setValueAtLocation(int location, double value) {
        this.values.setValueAtLocation(location, value);
    }

    public int indexAtLocation(int location) {
        return this.values.indexAtLocation(location);
    }

    public double dotProduct(ConstantMatrix m) {
        return this.values.dotProduct(m);
    }

    public double absNorm() {
        return this.values.absNorm();
    }

    public double oneNorm() {
        return this.values.oneNorm();
    }

    public double twoNorm() {
        return this.values.twoNorm();
    }

    public double infinityNorm() {
        return this.values.infinityNorm();
    }

    public void print() {
        this.values.print();
    }

    public boolean isNaN() {
        return this.values.isNaN();
    }

    public void setSingleValue(int i, double value) {
        this.values.setValue(i, value);
    }

    public void incrementSingleValue(int i, double delta) {
        double value = this.values.value(i);
        this.values.setValue(i, value + delta);
    }

    public void setAll(double v) {
        this.values.setAll(v);
    }

    public void set(ConstantMatrix m) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public void setWithAddend(ConstantMatrix m, double addend) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public void setWithFactor(ConstantMatrix m, double factor) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public void plusEquals(ConstantMatrix m) {
        this.values.plusEqualsSparse((SparseVector)m);
    }

    public void plusEquals(ConstantMatrix m, double factor) {
        this.values.plusEqualsSparse((SparseVector)m, factor);
    }

    public void equalsPlus(double factor, ConstantMatrix m) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public void timesEquals(double factor) {
        this.values.timesEquals(factor);
    }

    public void elementwiseTimesEquals(ConstantMatrix m) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public void elementwiseTimesEquals(ConstantMatrix m, double factor) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public void divideEquals(double factor) {
        this.values.timesEquals(1.0 / factor);
    }

    public void elementwiseDivideEquals(ConstantMatrix m) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public void elementwiseDivideEquals(ConstantMatrix m, double factor) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public double oneNormalize() {
        double norm = this.values.oneNorm();
        this.values.timesEquals(1.0 / norm);
        return norm;
    }

    public double twoNormalize() {
        double norm = this.values.twoNorm();
        this.values.timesEquals(1.0 / norm);
        return norm;
    }

    public double absNormalize() {
        double norm = this.values.absNorm();
        this.values.timesEquals(1.0 / norm);
        return norm;
    }

    public double infinityNormalize() {
        double norm = this.values.infinityNorm();
        this.values.timesEquals(1.0 / norm);
        return norm;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(1);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int version = in.readInt();
    }
}

