/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import pnuts.lang.Binding;
import pnuts.lang.NamedValue;
import pnuts.lang.SymbolTable;

class StackFrame {
    StackFrame parent;
    SymbolTable symbolTable;

    StackFrame() {
        this.symbolTable = new SymbolTable();
    }

    StackFrame(String[] locals, StackFrame parent) {
        this.parent = parent;
        this.symbolTable = new SymbolTable();
        this.openLocal(locals);
    }

    public void openLocal(String[] locals) {
        this.symbolTable = new SymbolTable(this.symbolTable);
        for (int i = 0; i < locals.length; ++i) {
            this.symbolTable.set(locals[i], null);
        }
    }

    public void closeLocal() {
        this.symbolTable = this.symbolTable.parent;
    }

    public NamedValue lookup(String sym) {
        return this.symbolTable.lookup(sym);
    }

    public void assign(String sym, Object value) {
        this.symbolTable.assign(sym, value);
    }

    public void declare(String sym, Object value) {
        SymbolTable t = this.symbolTable;
        while (t.parent != null) {
            t = t.parent;
        }
        t.set(sym, value);
    }

    public final void bind(String sym, Object value) {
        this.symbolTable.set(sym, value);
    }

    void makeLexicalScope(SymbolTable out) {
        this.makeLexicalScope(this.symbolTable, out);
    }

    void makeLexicalScope(SymbolTable env, SymbolTable out) {
        if (env.parent != null) {
            this.makeLexicalScope(env.parent, out);
        }
        int i = 0;
        int j = 0;
        while (i < env.count) {
            Binding b = env.table[j];
            while (b != null) {
                out.assign(b.name, b);
                ++i;
                b = b.chain;
            }
            ++j;
        }
    }
}

