/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.data.Adjective;
import net.didion.jwnl.data.DictionaryElementFactory;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.VerbFrame;
import net.didion.jwnl.dictionary.Dictionary;
import net.didion.jwnl.util.ResourceBundleSet;
import net.didion.jwnl.util.factory.Element;
import net.didion.jwnl.util.factory.Param;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class JWNL {
    public static final OS WINDOWS = new OS("windows");
    public static final OS UNIX = new OS("unix");
    public static final OS MAC = new OS("mac");
    public static final OS UNDEFINED = new OS("undefined");
    public static final OS[] DEFINED_OS_ARRAY = new OS[]{WINDOWS, UNIX, MAC};
    public static final String OS_PROPERTY_NAME = "os.name";
    private static final String JAVA_VERSION_PROPERTY = "java.version";
    private static final String CORE_RESOURCE = "JWNLResource";
    private static final int UNINITIALIZED = 0;
    private static final int START = 1;
    private static final int DICTIONARY_PATH_SET = 2;
    private static final int VERSION_SET = 3;
    private static final int INITIALIZED = 4;
    private static Version _version;
    private static ResourceBundleSet _bundle;
    private static OS _currentOS;
    private static int _initStage;
    private static final String VERSION_TAG = "version";
    private static final String DICTIONARY_TAG = "dictionary";
    private static final String PARAM_TAG = "param";
    private static final String DICTIONARY_ELEMENT_FACTORY_TAG = "dictionary_element_factory";
    private static final String RESOURCE_TAG = "resource";
    private static final String LANGUAGE_ATTRIBUTE = "language";
    private static final String COUNTRY_ATTRIBUTE = "country";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String PUBLISHER_ATTRIBUTE = "publisher";
    private static final String NUMBER_ATTRIBUTE = "number";

    private JWNL() {
    }

    public static void initialize(InputStream inputStream) throws JWNLException {
        Object object;
        Object object2;
        Object object3;
        JWNL.checkInitialized(0);
        _initStage = 1;
        try {
            if (inputStream == null || inputStream.available() <= 0) {
                throw new JWNLException("JWNL_EXCEPTION_001");
            }
        }
        catch (IOException iOException) {
            throw new JWNLException("JWNL_EXCEPTION_001", iOException);
        }
        Document document = null;
        try {
            object3 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object3).setValidating(false);
            object2 = ((DocumentBuilderFactory)object3).newDocumentBuilder();
            document = ((DocumentBuilder)object2).parse(inputStream);
        }
        catch (Exception exception) {
            throw new JWNLException("JWNL_EXCEPTION_002", exception);
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object3 = document.getDocumentElement();
        _bundle.setLocale(JWNL.getLocale(JWNL.getAttribute((Node)object3, LANGUAGE_ATTRIBUTE), JWNL.getAttribute((Node)object3, COUNTRY_ATTRIBUTE)));
        object2 = object3.getElementsByTagName(RESOURCE_TAG);
        int n = 0;
        while (n < object2.getLength()) {
            object = JWNL.getAttribute(object2.item(n), CLASS_ATTRIBUTE);
            if (object != null) {
                _bundle.addResource((String)object);
            }
            ++n;
        }
        POS.initialize();
        PointerType.initialize();
        Adjective.initialize();
        VerbFrame.initialize();
        object = object3.getElementsByTagName(VERSION_TAG);
        if (object.getLength() == 0) {
            throw new JWNLException("JWNL_EXCEPTION_003");
        }
        Node node = object.item(0);
        _initStage = 2;
        String string = JWNL.getAttribute(node, NUMBER_ATTRIBUTE);
        _version = new Version(JWNL.getAttribute(node, PUBLISHER_ATTRIBUTE), string == null ? 0.0 : Double.parseDouble(string), JWNL.getLocale(JWNL.getAttribute(node, LANGUAGE_ATTRIBUTE), JWNL.getAttribute(node, COUNTRY_ATTRIBUTE)));
        _initStage = 3;
        NodeList nodeList = object3.getElementsByTagName(DICTIONARY_TAG);
        if (nodeList.getLength() == 0) {
            throw new JWNLException("JWNL_EXCEPTION_005");
        }
        JWNL.createElementFromNode(nodeList.item(0)).install();
        NodeList nodeList2 = object3.getElementsByTagName(DICTIONARY_ELEMENT_FACTORY_TAG);
        if (nodeList2.getLength() > 0) {
            JWNL.createElementFromNode(nodeList2.item(0)).install();
        }
        _initStage = 4;
    }

    private static void createResourceBundle() {
        _bundle = new ResourceBundleSet(CORE_RESOURCE);
    }

    private static Element createElementFromNode(Node node) {
        return new Element(JWNL.getAttribute(node, CLASS_ATTRIBUTE), JWNL.getParams(node.getChildNodes()));
    }

    private static Param[] getParams(NodeList nodeList) {
        ArrayList<Param> arrayList = new ArrayList<Param>();
        if (nodeList != null) {
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node.getNodeType() == 1 && node.getNodeName().equals(PARAM_TAG)) {
                    String string = JWNL.getAttribute(node, NAME_ATTRIBUTE).toLowerCase();
                    String string2 = JWNL.getAttribute(node, VALUE_ATTRIBUTE);
                    if (node.hasChildNodes()) {
                        arrayList.add(new Param(string, string2, JWNL.getParams(node.getChildNodes())));
                    } else {
                        arrayList.add(new Param(string, string2));
                    }
                }
                ++n;
            }
        }
        return arrayList.toArray(new Param[arrayList.size()]);
    }

    private static String getAttribute(Node node, String string) {
        Node node2;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (node2 = namedNodeMap.getNamedItem(string)) != null) {
            return node2.getNodeValue();
        }
        return null;
    }

    private static Locale getLocale(String string, String string2) {
        if (string == null) {
            return Locale.getDefault();
        }
        if (string2 == null) {
            return new Locale(string, "");
        }
        return new Locale(string, string2);
    }

    public static boolean isInitialized() {
        return _initStage == 4;
    }

    public static OS getOS() {
        return _currentOS;
    }

    public static double getJavaVersion() {
        String string = System.getProperty(JAVA_VERSION_PROPERTY);
        return Double.parseDouble(string.substring(0, 3));
    }

    public static Version getVersion() {
        JWNL.checkInitialized(3);
        return _version;
    }

    public static ResourceBundle getResourceBundle() {
        return _bundle;
    }

    public static String resolveMessage(String string) {
        return JWNL.resolveMessage(string, new Object[0]);
    }

    public static String resolveMessage(String string, Object object) {
        return JWNL.resolveMessage(string, new Object[]{object});
    }

    public static String resolveMessage(String string, Object[] objectArray) {
        JWNL.checkInitialized(0);
        return JWNL.insertParams(_bundle.getString(string), objectArray);
    }

    private static String insertParams(String string, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length && n <= string.length()) {
            int n3 = string.indexOf("{" + n2, n);
            if (n3 != -1) {
                stringBuffer.append(string.substring(n, n3));
                stringBuffer.append(objectArray[n2] == null ? null : objectArray[n2].toString());
                n = n3 + 3;
            }
            ++n2;
        }
        stringBuffer.append(string.substring(n, string.length()));
        return stringBuffer.toString();
    }

    private static void checkInitialized(int n) {
        if (n > _initStage) {
            throw new JWNLRuntimeException("JWNL_EXCEPTION_007");
        }
    }

    public static void shutdown() {
        _initStage = 0;
        Dictionary.uninstall();
        DictionaryElementFactory.uninstall();
        _version = null;
        JWNL.createResourceBundle();
    }

    static {
        _currentOS = UNDEFINED;
        _initStage = 0;
        JWNL.createResourceBundle();
        String string = System.getProperty(OS_PROPERTY_NAME);
        int n = 0;
        while (n < DEFINED_OS_ARRAY.length) {
            if (DEFINED_OS_ARRAY[n].matches(string)) {
                _currentOS = DEFINED_OS_ARRAY[n];
            }
            ++n;
        }
    }

    public static final class Version {
        private static final String UNSPECIFIED = "unspecified";
        private String _publisher;
        private double _number;
        private Locale _locale;

        public Version(String string, double d, Locale locale) {
            if (string == null) {
                string = UNSPECIFIED;
            }
            this._publisher = string;
            this._number = d;
            this._locale = locale;
        }

        public String getPublisher() {
            return this._publisher;
        }

        public double getNumber() {
            return this._number;
        }

        public Locale getLocale() {
            return this._locale;
        }

        public boolean equals(Object object) {
            return object instanceof Version && this._publisher.equals(((Version)object)._publisher) && this._number == ((Version)object)._number && this._locale.equals(((Version)object)._locale);
        }

        public String toString() {
            return JWNL.resolveMessage("JWNL_TOSTRING_002", new Object[]{this._publisher, new Double(this._number), this._locale});
        }

        public int hashCode() {
            return this._publisher.hashCode() ^ (int)(this._number * 100.0);
        }
    }

    public static final class OS {
        private String _name;

        protected OS(String string) {
            this._name = string;
        }

        public String toString() {
            return JWNL.resolveMessage("JWNL_TOSTRING_001", this._name);
        }

        public boolean matches(String string) {
            return string.toLowerCase().indexOf(this._name.toLowerCase()) >= 0;
        }
    }
}

