/*
 * Decompiled with CFR 0.152.
 */
package Jet.Scorer;

import Jet.Console;
import Jet.Lisp.FeatureSet;
import Jet.Pat.PatternSyntaxError;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class SGMLProcessor {
    public static boolean includeWhitespace = true;
    private static final int COLLECTING_TEXT = 0;
    private static final int COLLECTING_TYPE = 1;
    private static final int COLLECTING_FEATURE = 2;
    private static final int COLLECTING_VALUE = 3;
    private static final int COLLECTING_ESCAPED_VALUE = 4;
    private static final int COLLECTING_TAG_END = 5;
    private static final int SKIPPING_XML_DECLARATION = 6;
    public static boolean allTags = false;
    public static String[] emptyTags = null;
    static Stack<String> openTagType;
    static Stack<Integer> openTagPosn;
    static Stack<FeatureSet> openTagFeatureSet;
    static ArrayList<Annotation> newAnnotations;
    static boolean strictNesting;
    static HashMap<String, Annotation> idToAnnotation;

    public static Document sgmlToDoc(String string, String string2) {
        Document document = new Document();
        return SGMLProcessor.sgmlToDoc(document, string, string2);
    }

    public static Document sgmlToDoc(Document document, String string) {
        document.clearAnnotations();
        return SGMLProcessor.sgmlToDoc(document, document.text(), string);
    }

    public static Document sgmlToDoc(Document document, String string, String string2) {
        String[] stringArray = new String[]{string2};
        return SGMLProcessor.sgmlToDoc(document, string, stringArray);
    }

    public static Document sgmlToDoc(String string, String[] stringArray) {
        Document document = new Document();
        return SGMLProcessor.sgmlToDoc(document, string, stringArray);
    }

    public static Document sgmlToDoc(Document document, String[] stringArray) {
        document.clearAnnotations();
        return SGMLProcessor.sgmlToDoc(document, document.text(), stringArray);
    }

    public static Document sgmlToDoc(Document document, String string, String[] stringArray) {
        newAnnotations = new ArrayList();
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        StringBuffer stringBuffer3 = null;
        StringBuffer stringBuffer4 = null;
        FeatureSet featureSet = null;
        String string2 = "";
        int n = 0;
        char c = ' ';
        int n2 = 0;
        String string3 = null;
        FeatureSet featureSet2 = null;
        openTagType = new Stack();
        openTagPosn = new Stack();
        openTagFeatureSet = new Stack();
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (n == 0) {
                if (c2 == '<') {
                    n = 1;
                    stringBuffer = new StringBuffer();
                    stringBuffer2 = new StringBuffer();
                    featureSet = new FeatureSet();
                    continue;
                }
                document.append(c2);
                continue;
            }
            if (n == 1) {
                if (Character.isWhitespace(c2)) {
                    if (stringBuffer.length() > 0 && !stringBuffer.equals("/")) {
                        string2 = stringBuffer.toString().intern();
                        if (string2 == "?xml") {
                            n = 6;
                            continue;
                        }
                        if (string2.charAt(0) != '/' && SGMLProcessor.tagToCapture(string2, stringArray)) {
                            n = 2;
                            stringBuffer3 = new StringBuffer();
                            stringBuffer4 = new StringBuffer();
                            continue;
                        }
                        document.append('<' + stringBuffer2.toString() + stringBuffer.toString() + ' ');
                        n = 0;
                        continue;
                    }
                    stringBuffer2.append(c2);
                    continue;
                }
                if (c2 == '/' && stringBuffer.length() > 0) {
                    string2 = stringBuffer.toString().intern();
                    n = 5;
                    continue;
                }
                if (c2 == '>') {
                    string2 = stringBuffer.toString();
                    if (string2.length() > 0 && string2.charAt(0) != '/' && SGMLProcessor.tagToCapture(string2, stringArray)) {
                        SGMLProcessor.endOfOpenTag(document, string2, featureSet);
                        n = 0;
                        continue;
                    }
                    if (string2.length() > 0 && string2.charAt(0) == '/' && SGMLProcessor.tagToCapture(string2.substring(1), stringArray)) {
                        int n3 = openTagType.search(string2.substring(1));
                        if (n3 > 0) {
                            int n4;
                            if (strictNesting) {
                                for (n4 = 1; n4 < n3; ++n4) {
                                    String string4 = openTagType.pop();
                                    Console.println("Error in SGML read:  unclosed " + string4 + " tag.");
                                    openTagPosn.pop();
                                    openTagFeatureSet.pop();
                                }
                            }
                            n4 = openTagType.size() - n3;
                            string3 = (String)openTagType.remove(n4);
                            n2 = (Integer)openTagPosn.remove(n4);
                            featureSet2 = (FeatureSet)openTagFeatureSet.remove(n4);
                            int n5 = document.length();
                            Annotation annotation = new Annotation(string3, new Span(n2, n5), featureSet2);
                            document.addAnnotation(annotation);
                            newAnnotations.add(annotation);
                            n = 0;
                            continue;
                        }
                        Console.println("Error in SGML read:  unmatched " + string2 + " tag at position " + i);
                        n = 0;
                        continue;
                    }
                    document.append('<' + stringBuffer2.toString() + stringBuffer.toString() + '>');
                    n = 0;
                    continue;
                }
                stringBuffer.append(c2);
                continue;
            }
            if (n == 2) {
                if (c2 == '=') {
                    n = 3;
                    c = ' ';
                    continue;
                }
                if (Character.isWhitespace(c2)) continue;
                if (c2 == '>') {
                    if (stringBuffer3.length() > 0) {
                        Console.println("Error in SGML read:  in tag " + string2 + ", feature " + stringBuffer3 + " not followed by value");
                    }
                    SGMLProcessor.endOfOpenTag(document, string2, featureSet);
                    n = 0;
                    continue;
                }
                if (c2 == '/') {
                    if (stringBuffer3.length() > 0) {
                        Console.println("Error in SGML read:  in tag " + string2 + ", feature " + stringBuffer3 + " not followed by value");
                    }
                    n = 5;
                    continue;
                }
                stringBuffer3.append(c2);
                continue;
            }
            if (n == 3) {
                if (stringBuffer4.length() == 0 && c == ' ' && (c2 == '\"' || c2 == '\'')) {
                    c = c2;
                    continue;
                }
                if (c == ' ' && c2 == '>') {
                    featureSet.put(stringBuffer3.toString().intern(), stringBuffer4.toString().intern());
                    SGMLProcessor.endOfOpenTag(document, string2, featureSet);
                    n = 0;
                    continue;
                }
                if (c == ' ' && Character.isWhitespace(c2) || c != ' ' && c2 == c) {
                    Object object = SGMLProcessor.decodeJetValue(stringBuffer4.toString());
                    featureSet.put(stringBuffer3.toString().intern(), object);
                    stringBuffer3 = new StringBuffer();
                    stringBuffer4 = new StringBuffer();
                    n = 2;
                    continue;
                }
                if (c2 == '\\') {
                    n = 4;
                    continue;
                }
                stringBuffer4.append(c2);
                continue;
            }
            if (n == 4) {
                stringBuffer4.append(c2);
                n = 3;
                continue;
            }
            if (n == 5) {
                if (Character.isWhitespace(c2)) continue;
                if (c2 == '>') {
                    Annotation annotation = new Annotation(string2, new Span(document.length(), document.length()), featureSet);
                    document.addAnnotation(annotation);
                    newAnnotations.add(annotation);
                    n = 0;
                    continue;
                }
                Console.println("Error in SGML read:  in tag " + string2 + " missing > after /");
                n = 0;
                continue;
            }
            if (n == 6) {
                if (c2 != '>') continue;
                n = 0;
                continue;
            }
            Console.println("Internal error in SGMLProcessor: invalid state");
            System.exit(1);
        }
        if (n != 0) {
            Console.println("Error in SGML read:  incomplete tag");
        }
        if (!openTagType.empty()) {
            Console.println("Error in SGML read:  unbalanced tags");
            while (!openTagType.empty()) {
                Console.println("  Unclosed tag " + openTagType.pop());
                Console.println(" " + openTagPosn.pop());
                Console.println(" " + openTagFeatureSet.pop());
            }
        }
        SGMLProcessor.dereference(document);
        return document;
    }

    private static void endOfOpenTag(Document document, String string, FeatureSet featureSet) {
        if (SGMLProcessor.emptyTag(string)) {
            Annotation annotation = new Annotation(string, new Span(document.length(), document.length()), featureSet);
            document.addAnnotation(annotation);
            newAnnotations.add(annotation);
        } else {
            openTagType.push(string);
            openTagPosn.push(new Integer(document.length()));
            openTagFeatureSet.push(featureSet);
        }
    }

    private static Object decodeJetValue(String string) {
        if (string.startsWith("{") && string.endsWith("}")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(1, string.length() - 1));
            int n = stringTokenizer.countTokens();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = stringTokenizer.nextToken().intern();
            }
            return objectArray;
        }
        if (string.startsWith("[") && string.endsWith("]")) {
            StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string.substring(1, string.length())));
            try {
                FeatureSet featureSet = new FeatureSet(streamTokenizer, false, ']');
                return featureSet;
            }
            catch (IOException iOException) {
                System.out.println("SGMLProcessor:  error in reading featureSet, " + string + "\n" + iOException);
                return null;
            }
            catch (PatternSyntaxError patternSyntaxError) {
                System.out.println("SGMLProcessor:  error in reading featureSet, " + string + "\n" + patternSyntaxError);
                return null;
            }
        }
        return string.intern();
    }

    private static boolean tagToCapture(String string, String[] stringArray) {
        if (allTags) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean emptyTag(String string) {
        if (emptyTags == null) {
            return false;
        }
        for (int i = 0; i < emptyTags.length; ++i) {
            if (!string.equalsIgnoreCase(emptyTags[i])) continue;
            return true;
        }
        return false;
    }

    public static void dereference(Document document) {
        Object object;
        Annotation annotation;
        int n;
        Vector<Annotation> vector;
        int n2;
        idToAnnotation = new HashMap();
        String[] stringArray = document.getAnnotationTypes();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            vector = document.annotationsOfType(stringArray[n2]);
            for (n = 0; n < vector.size(); ++n) {
                annotation = vector.get(n);
                object = (String)annotation.get("id");
                if (object == null) continue;
                idToAnnotation.put((String)object, annotation);
            }
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            vector = document.annotationsOfType(stringArray[n2]);
            for (n = 0; n < vector.size(); ++n) {
                annotation = vector.get(n);
                object = annotation.attributes();
                Enumeration enumeration = ((FeatureSet)object).keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    Object object2 = ((FeatureSet)object).get(string);
                    if (SGMLProcessor.isAnnotationReference(object2)) {
                        ((FeatureSet)object).put(string, SGMLProcessor.resolveAnnotationReference(object2));
                        continue;
                    }
                    if (!(object2 instanceof Object[])) continue;
                    Object[] objectArray = (Object[])object2;
                    boolean bl = true;
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (SGMLProcessor.isAnnotationReference(objectArray[i])) {
                            objectArray[i] = SGMLProcessor.resolveAnnotationReference(objectArray[i]);
                            continue;
                        }
                        bl = false;
                    }
                    if (!bl) continue;
                    Annotation[] annotationArray = new Annotation[objectArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        annotationArray[i] = (Annotation)objectArray[i];
                    }
                    ((FeatureSet)object).put(string, annotationArray);
                }
            }
        }
    }

    private static boolean isAnnotationReference(Object object) {
        return object instanceof String && ((String)object).length() > 0 && ((String)object).charAt(0) == '#';
    }

    private static Object resolveAnnotationReference(Object object) {
        String string = ((String)object).substring(1);
        Annotation annotation = idToAnnotation.get(string);
        if (annotation == null) {
            System.out.println("Undefined annotation reference " + object);
            return null;
        }
        return annotation;
    }

    private static void stretchAnnotations(Document document, ArrayList arrayList) {
        Annotation annotation;
        int n;
        int n2 = document.length();
        boolean[] blArray = new boolean[n2];
        for (n = 0; n < arrayList.size(); ++n) {
            annotation = (Annotation)arrayList.get(n);
            blArray[annotation.start()] = true;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            int n3;
            annotation = (Annotation)arrayList.get(n);
            document.removeAnnotation(annotation);
            Span span = annotation.span();
            for (n3 = span.end(); n3 < n2 && !blArray[n3] && Character.isWhitespace(document.charAt(n3)); ++n3) {
            }
            span.setEnd(n3);
            document.addAnnotation(annotation);
        }
    }

    static {
        strictNesting = false;
    }
}

