/*
 * Decompiled with CFR 0.152.
 */
package Jet.Scorer;

import Jet.Console;
import Jet.HMM.BigramHMMemitter;
import Jet.HMM.HMMNameTagger;
import Jet.HMM.WordFeatureHMMemitter;
import Jet.Scorer.NameTagger;
import Jet.Scorer.SGMLScorer;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.DocumentCollection;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import java.io.IOException;
import java.util.Vector;

public class NEScorer {
    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length < 5) {
            NEScorer.argErr();
        }
        DocumentCollection documentCollection = new DocumentCollection(stringArray[0], stringArray[1]);
        DocumentCollection documentCollection2 = new DocumentCollection(stringArray[2], stringArray[3]);
        HMMNameTagger hMMNameTagger = null;
        int n = 4;
        if (stringArray[4].equals("unigram") || stringArray[4].equals("bigram")) {
            boolean bl;
            if (stringArray.length < 7) {
                NEScorer.argErr();
            }
            hMMNameTagger = new HMMNameTagger((bl = stringArray[4].equals("bigram")) ? BigramHMMemitter.class : WordFeatureHMMemitter.class);
            hMMNameTagger.load(stringArray[5]);
            n = 6;
        }
        String[] stringArray2 = new String[stringArray.length - n];
        for (int i = 0; i < stringArray.length - n; ++i) {
            stringArray2[i] = stringArray[n + i];
        }
        NEScorer.scoreCollection((NameTagger)hMMNameTagger, documentCollection, documentCollection2, stringArray2);
    }

    private static void argErr() {
        System.err.println("NEScorer requires 5 or more arguments:");
        System.err.print("         test-directory test-file-list key-directory key-file-list");
        System.err.println(" [uni/bigram tagger-model] tag ...");
        System.exit(1);
    }

    public static void scoreCollection(NameTagger nameTagger, String string, String string2, String[] stringArray) {
        DocumentCollection documentCollection = new DocumentCollection(string);
        DocumentCollection documentCollection2 = new DocumentCollection(string2);
        NEScorer.scoreCollection(nameTagger, documentCollection, documentCollection2, stringArray);
    }

    public static void scoreCollection(NameTagger nameTagger, DocumentCollection documentCollection, DocumentCollection documentCollection2, String[] stringArray) {
        documentCollection.open();
        documentCollection2.open();
        if (documentCollection.size() != documentCollection2.size()) {
            System.out.println(" ** Test and key collections have different sizes, cannot evaluate.");
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < documentCollection.size(); ++i) {
            ExternalDocument externalDocument = documentCollection.get(i);
            externalDocument.setAllTags(true);
            externalDocument.open();
            externalDocument.stretchAll();
            System.out.println("Scoring " + externalDocument.fileName());
            if (nameTagger != null) {
                nameTagger.tagDocument(externalDocument);
            }
            ExternalDocument externalDocument2 = documentCollection2.get(i);
            externalDocument2.setAllTags(true);
            externalDocument2.open();
            externalDocument2.stretchAll();
            Vector<Annotation> vector = externalDocument2.annotationsOfType("TEXT");
            if (vector == null) {
                System.out.println("No <TEXT> in " + externalDocument.fileName() + ", cannot be scored.");
                continue;
            }
            Span span = vector.get(0).span();
            for (String string : stringArray) {
                NEScorer.eraseAnnotationsOutside(externalDocument2, string, span);
            }
            SGMLScorer sGMLScorer = new SGMLScorer(externalDocument, externalDocument2);
            for (String string : stringArray) {
                sGMLScorer.match(string);
                Console.println(sGMLScorer.report());
            }
            System.out.println("Total tags in response:  " + sGMLScorer.totalTagsInDoc1);
            System.out.println("Total tags in key:       " + sGMLScorer.totalTagsInDoc2);
            System.out.println("Matching tags:           " + sGMLScorer.totalMatchingTags);
            System.out.println("Matching attributes:     " + sGMLScorer.totalMatchingAttrs);
            System.out.println("Type recall:             " + (float)sGMLScorer.totalMatchingTags / (float)sGMLScorer.totalTagsInDoc2);
            System.out.println("Type precision:          " + (float)sGMLScorer.totalMatchingTags / (float)sGMLScorer.totalTagsInDoc1);
            System.out.println("Attribute recall:        " + (float)sGMLScorer.totalMatchingAttrs / (float)sGMLScorer.totalTagsInDoc2);
            System.out.println("Attribute precision:     " + (float)sGMLScorer.totalMatchingAttrs / (float)sGMLScorer.totalTagsInDoc1);
            n += sGMLScorer.totalTagsInDoc1;
            n2 += sGMLScorer.totalTagsInDoc2;
            n3 += sGMLScorer.totalMatchingTags;
            n4 += sGMLScorer.totalMatchingAttrs;
        }
        System.out.println("Overall Type Recall:          " + (float)n3 / (float)n2);
        System.out.println("Overall Type Precision:       " + (float)n3 / (float)n);
        System.out.println("Overall Attribute Recall:     " + (float)n4 / (float)n2);
        System.out.println("Overall Attribute Precision:  " + (float)n4 / (float)n);
    }

    private static void eraseAnnotationsOutside(Document document, String string, Span span) {
        Vector vector = document.annotationsOfType(string);
        if (vector == null) {
            return;
        }
        vector = (Vector)vector.clone();
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = (Annotation)vector.get(i);
            if (annotation.span().within(span)) continue;
            document.removeAnnotation(annotation);
        }
    }
}

