/*
 * Decompiled with CFR 0.152.
 */
package Jet.NE;

import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import edu.umass.cs.mallet.base.pipe.Pipe;
import edu.umass.cs.mallet.base.types.Instance;
import edu.umass.cs.mallet.base.types.LabelAlphabet;
import edu.umass.cs.mallet.base.types.LabelSequence;
import edu.umass.cs.mallet.base.types.Token;
import edu.umass.cs.mallet.base.types.TokenSequence;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class SentenceToTokenSequencePipe
extends Pipe {
    public SentenceToTokenSequencePipe() {
        super(null, LabelAlphabet.class);
    }

    public Instance pipe(Instance instance) {
        Span span;
        Document document = (Document)instance.getSource();
        List<Annotation> list = document.annotationsOfType("ENAMEX", span = (Span)instance.getData());
        if (list == null) {
            list = Collections.emptyList();
        }
        Annotation.sortByStartPosition(list);
        TokenSequence tokenSequence = new TokenSequence();
        LabelSequence labelSequence = new LabelSequence((LabelAlphabet)this.getTargetAlphabet());
        int n = span.start();
        for (Annotation annotation : list) {
            if (annotation.start() > n) {
                this.addTokens(tokenSequence, labelSequence, document, new Span(n, annotation.start()), "O");
            }
            this.addTokens(tokenSequence, labelSequence, document, annotation.span(), (String)annotation.get("TYPE"));
            n = annotation.end();
        }
        if (n < span.end()) {
            this.addTokens(tokenSequence, labelSequence, document, new Span(n, span.end()), "O");
        }
        instance.setData(tokenSequence);
        instance.setSource(tokenSequence);
        instance.setTarget(labelSequence);
        instance.setProperty("document", document);
        instance.setProperty("span", span);
        return instance;
    }

    private void addTokens(TokenSequence tokenSequence, LabelSequence labelSequence, Document document, Span span, String string) {
        Vector<Annotation> vector = document.annotationsOfType("token", span);
        if (vector == null) {
            return;
        }
        Annotation.sortByStartPosition(vector);
        if (string.equals("O")) {
            for (Annotation annotation : vector) {
                tokenSequence.add(this.makeToken(document, annotation));
                labelSequence.add(string);
            }
        } else {
            tokenSequence.add(this.makeToken(document, (Annotation)vector.get(0)));
            labelSequence.add("B-" + string);
            String string2 = "I-" + string;
            for (int i = 1; i < vector.size(); ++i) {
                Annotation annotation = (Annotation)vector.get(i);
                tokenSequence.add(this.makeToken(document, annotation));
                labelSequence.add(string2);
            }
        }
    }

    private Token makeToken(Document document, Annotation annotation) {
        Token token = new Token(document.normalizedText(annotation));
        token.setProperty("span", annotation.span());
        return token;
    }
}

