/*
 * Decompiled with CFR 0.152.
 */
package pnuts.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import pnuts.compiler.ClassFile;
import pnuts.compiler.ClassFileHandler;
import pnuts.compiler.Compiler;
import pnuts.compiler.FileWriterHandler;
import pnuts.compiler.ZipWriterHandler;
import pnuts.lang.ParseException;
import pnuts.lang.Pnuts;
import pnuts.tools.Main;

public class PnutsCompiler {
    private boolean verbose = false;
    private boolean useDynamicProxy = true;
    private boolean includeMain = false;
    private boolean includeLineNumber = true;
    static String file_sep = System.getProperty("file.separator");
    static String prefix;

    public void setVerbose(boolean flag) {
        this.verbose = flag;
    }

    public void includeMainMethod(boolean flag) {
        this.includeMain = flag;
    }

    public void includeLineNumber(boolean flag) {
        this.includeLineNumber = flag;
    }

    Compiler getCompiler(String name) {
        Compiler compiler = new Compiler(name, false, this.useDynamicProxy);
        compiler.includeMainMethod(this.includeMain);
        compiler.includeLineNo(this.includeLineNumber);
        return compiler;
    }

    public void useDynamicProxy(boolean flag) {
        this.useDynamicProxy = flag;
    }

    public static void setClassPrefix(String p) {
        prefix = p;
    }

    public void compileToZip(Pnuts p, String name, ZipOutputStream zout) {
        ZipWriterHandler handler = new ZipWriterHandler(zout);
        if (this.verbose) {
            handler.setVerbose(true);
        }
        this.getCompiler(name).compile(p, (ClassFileHandler)handler);
    }

    public void compileToFile(Pnuts p, String name, File dir) {
        FileWriterHandler handler = new FileWriterHandler(dir);
        if (this.verbose) {
            handler.setVerbose(true);
        }
        this.getCompiler(name).compile(p, (ClassFileHandler)handler);
    }

    void compileToZip(File file, ZipOutputStream zout, Vector classNames, String encoding) throws IOException, ParseException {
        String ext;
        String fileName = file.getName();
        int idx = fileName.lastIndexOf(46);
        if (idx > 0 && ("jar".equals(ext = fileName.substring(idx + 1).toLowerCase()) || "zip".equals(ext))) {
            ZipFile zfile = new ZipFile(file);
            Enumeration<? extends ZipEntry> e = zfile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(".pnut")) continue;
                if (this.verbose) {
                    System.out.println(entryName);
                }
                InputStream in = zfile.getInputStream(entry);
                InputStreamReader reader = encoding == null ? new InputStreamReader(in) : new InputStreamReader(in, encoding);
                Pnuts p = Pnuts.parse(reader);
                try {
                    p.setScriptSource(new URL("jar:" + file.toURL() + "!/" + entryName));
                }
                catch (MalformedURLException mue) {
                    // empty catch block
                }
                String className = PnutsCompiler.className(entryName);
                this.compileToZip(p, className, zout);
                classNames.addElement(className);
            }
            return;
        }
        InputStreamReader reader = encoding == null ? new FileReader(file) : new InputStreamReader((InputStream)new FileInputStream(file), encoding);
        Pnuts pn = Pnuts.parse(reader);
        pn.setScriptSource(file.toURL());
        String className = PnutsCompiler.className(fileName);
        this.compileToZip(pn, className, zout);
        classNames.addElement(className);
    }

    void compileToFile(File file, File dir, Vector classNames, String encoding) throws IOException, ParseException {
        String ext;
        String fileName = file.getName();
        int idx = fileName.lastIndexOf(46);
        if (idx > 0 && ("jar".equals(ext = fileName.substring(idx + 1).toLowerCase()) || "zip".equals(ext))) {
            ZipFile zfile = new ZipFile(file);
            Enumeration<? extends ZipEntry> e = zfile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(".pnut")) continue;
                if (this.verbose) {
                    System.out.println(entryName);
                }
                InputStream in = zfile.getInputStream(entry);
                InputStreamReader reader = encoding == null ? new InputStreamReader(in) : new InputStreamReader(in, encoding);
                Pnuts p = Pnuts.parse(reader);
                try {
                    p.setScriptSource(new URL("jar:" + file.toURL() + "!/" + entryName));
                }
                catch (MalformedURLException mue) {
                    // empty catch block
                }
                String className = PnutsCompiler.className(entryName);
                this.compileToFile(p, className, dir);
                classNames.addElement(className);
            }
            return;
        }
        InputStreamReader reader = encoding == null ? new FileReader(file) : new InputStreamReader((InputStream)new FileInputStream(file), encoding);
        Pnuts pn = Pnuts.parse(reader);
        pn.setScriptSource(file.toURL());
        String className = PnutsCompiler.className(fileName);
        this.compileToFile(pn, className, dir);
        classNames.addElement(className);
    }

    static String className(String name) {
        int pos = name.lastIndexOf(46);
        String cname = name.replace('-', '_');
        if (pos > 0) {
            cname = cname.substring(0, pos).replace(file_sep.charAt(0), '.');
            if (!"/".equals(file_sep)) {
                cname = cname.replace('/', '.');
            }
        }
        if (prefix != null) {
            if (!"".equals(prefix) && !prefix.endsWith(".")) {
                prefix = prefix + ".";
            }
            cname = prefix + cname;
        }
        return cname;
    }

    public static ClassFile generateMainClass(String mainClassName, String arg0, String[] modules, String[] classNames, String pnutsImplClassName) {
        int i;
        ClassFile cf = new ClassFile(mainClassName, "pnuts.lang.Runtime", null, 1);
        cf.openMethod("<init>", "()V", (short)1);
        cf.add((byte)42);
        cf.add((byte)-73, "pnuts.lang.Runtime", "<init>", "()", "V");
        cf.add((byte)-79);
        cf.closeMethod();
        cf.openMethod("run", "(Lpnuts/lang/Context;)Ljava/lang/Object;", (short)1);
        cf.add((byte)43);
        int ctx = cf.getLocal();
        cf.storeLocal(ctx);
        for (i = 0; i < modules.length; ++i) {
            cf.loadLocal(ctx);
            cf.add((byte)18, cf.addConstant(modules[i]));
            cf.add((byte)-74, "pnuts.lang.Context", "usePackage", "(Ljava/lang/String;)", "Z");
            cf.add((byte)87);
        }
        for (i = 0; i < classNames.length; ++i) {
            if (i > 0) {
                cf.add((byte)87);
            }
            String name = classNames[i];
            cf.add((byte)-69, name);
            cf.add((byte)89);
            cf.add((byte)-73, name, "<init>", "()", "V");
            cf.loadLocal(ctx);
            cf.add((byte)-74, "pnuts.lang.Context", "clone", "()", "Ljava/lang/Object;");
            cf.add((byte)-64, "pnuts.lang.Context");
            cf.add((byte)-74, name, "run", "(Lpnuts/lang/Context;)", "Ljava/lang/Object;");
        }
        cf.add((byte)-80);
        cf.closeMethod();
        cf.openMethod("main", "([Ljava/lang/String;)V", (short)9);
        cf.add((byte)42);
        cf.add((byte)-66);
        int len = cf.getLocal();
        cf.istoreLocal(len);
        cf.iloadLocal(len);
        cf.add((byte)4);
        cf.add((byte)96);
        cf.add((byte)-67, "java.lang.String");
        int array = cf.getLocal();
        cf.storeLocal(array);
        cf.add((byte)42);
        cf.add((byte)3);
        cf.loadLocal(array);
        cf.add((byte)4);
        cf.iloadLocal(len);
        cf.add((byte)-72, "java.lang.System", "arraycopy", "(Ljava/lang/Object;ILjava/lang/Object;II)", "V");
        cf.loadLocal(array);
        cf.pushInteger(0);
        cf.add((byte)18, cf.addConstant(arg0));
        cf.add((byte)83);
        cf.add((byte)-69, "pnuts.lang.Context");
        cf.add((byte)89);
        cf.add((byte)-73, "pnuts.lang.Context", "<init>", "()", "V");
        ctx = cf.getLocal();
        cf.storeLocal(ctx);
        cf.loadLocal(ctx);
        cf.add((byte)-74, "pnuts.lang.Context", "getCurrentPackage", "()", "Lpnuts/lang/Package;");
        cf.add((byte)18, cf.addConstant("$args"));
        cf.add((byte)-74, "java.lang.String", "intern", "()", "Ljava/lang/String;");
        cf.loadLocal(array);
        cf.add((byte)-74, "pnuts.lang.Package", "set", "(Ljava/lang/String;Ljava/lang/Object;)", "V");
        cf.add((byte)-69, mainClassName);
        cf.add((byte)89);
        cf.add((byte)-73, mainClassName, "<init>", "()", "V");
        if (pnutsImplClassName != null) {
            cf.loadLocal(ctx);
            cf.add((byte)-69, pnutsImplClassName);
            cf.add((byte)89);
            cf.add((byte)-73, pnutsImplClassName, "<init>", "()", "V");
            cf.add((byte)-74, "pnuts.lang.Context", "setImplementation", "(Lpnuts/lang/Implementation;)", "V");
        }
        cf.loadLocal(ctx);
        cf.add((byte)-71, "pnuts.lang.Executable", "run", "(Lpnuts/lang/Context;)", "Ljava/lang/Object;");
        cf.add((byte)87);
        cf.add((byte)-79);
        cf.closeMethod();
        return cf;
    }

    static void setProperty(String name, String value) {
        Properties prop = System.getProperties();
        ((Hashtable)prop).put(name, value);
        System.setProperties(prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileToZip(ZipOutputStream zout, String[] files, String[] dirs, String[] modules, String mainClassName, String pnutsImplClassName, String encoding) throws IOException, ParseException {
        if (mainClassName != null) {
            ZipEntry meta_inf = new ZipEntry("meta-inf/manifest.mf");
            String manifest = "Manifest-Version: 1.0\nMain-Class: " + mainClassName + "\nCreated-By: pnutsc\n";
            zout.putNextEntry(meta_inf);
            zout.write(manifest.getBytes());
        }
        String currentDir = System.getProperty("user.dir");
        try {
            Vector classNames = new Vector();
            for (int i = 0; i < files.length; ++i) {
                String fileName = files[i];
                PnutsCompiler.setProperty("user.dir", new File(dirs[i]).getCanonicalPath());
                this.compileToZip(new File(fileName), zout, classNames, encoding);
            }
            if (mainClassName != null) {
                String[] classNameArray = new String[classNames.size()];
                for (int i = 0; i < classNameArray.length; ++i) {
                    classNameArray[i] = (String)classNames.elementAt(i);
                }
                ZipEntry entry = new ZipEntry(mainClassName.replace('.', '/') + ".class");
                zout.putNextEntry(entry);
                ClassFile cf = PnutsCompiler.generateMainClass(mainClassName, files[0], modules, classNameArray, pnutsImplClassName);
                cf.write(zout);
            }
        }
        finally {
            PnutsCompiler.setProperty("user.dir", currentDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileToFile(File dir, String[] files, String[] dirs, String[] modules, String mainClassName, String pnutsImplClassName, String encoding) throws IOException, ParseException {
        if (mainClassName != null) {
            File meta_dir = new File(dir, "meta-inf");
            if (!meta_dir.exists()) {
                meta_dir.mkdirs();
            }
            String manifest = "Manifest-Version: 1.0\nMain-Class: " + mainClassName + "\nCreated-By: pnutsc\n";
            FileOutputStream fout = new FileOutputStream(new File(meta_dir, "manifest.mf"));
            fout.write(manifest.getBytes());
            fout.close();
        }
        Vector classNames = new Vector();
        String currentDir = System.getProperty("user.dir");
        try {
            for (int i = 0; i < files.length; ++i) {
                String fileName = files[i];
                PnutsCompiler.setProperty("user.dir", new File(dirs[i]).getCanonicalPath());
                this.compileToFile(new File(fileName), dir, classNames, encoding);
            }
            if (mainClassName != null) {
                String[] classNameArray = new String[classNames.size()];
                for (int i = 0; i < classNameArray.length; ++i) {
                    classNameArray[i] = (String)classNames.elementAt(i);
                }
                FileOutputStream main = new FileOutputStream(new File(dir, mainClassName.replace('.', '/') + ".class"));
                ClassFile cf = PnutsCompiler.generateMainClass(mainClassName, files[0], modules, classNameArray, pnutsImplClassName);
                cf.write(main);
                main.close();
            }
        }
        finally {
            PnutsCompiler.setProperty("user.dir", currentDir);
        }
    }

    public static void main(String[] args) throws Throwable {
        String dest;
        int nargs = args.length;
        if (nargs == 0) {
            Main.printHelp("pnutsc");
            return;
        }
        PnutsCompiler compiler = new PnutsCompiler();
        String base = dest = System.getProperty("user.dir");
        String jar = null;
        Vector<String> files = new Vector<String>();
        Vector<String> dirs = new Vector<String>();
        Vector<String> modules = new Vector<String>();
        boolean module = false;
        String mainClassName = null;
        String pnutsImpl = null;
        String encoding = null;
        for (int i = 0; i < nargs; ++i) {
            if ("-d".equals(args[i])) {
                dest = args[++i];
                continue;
            }
            if ("-no_proxy".equals(args[i])) {
                compiler.useDynamicProxy(false);
                continue;
            }
            if ("-o".equals(args[i])) {
                jar = args[++i];
                continue;
            }
            if ("-v".equals(args[i])) {
                compiler.setVerbose(true);
                continue;
            }
            if ("-O".equals(args[i])) {
                compiler.includeLineNumber(false);
                continue;
            }
            if ("-C".equals(args[i])) {
                base = args[++i];
                continue;
            }
            if ("-prefix".equals(args[i])) {
                prefix = args[++i];
                continue;
            }
            if ("-main".equals(args[i])) {
                mainClassName = args[++i];
                continue;
            }
            if ("-m".equals(args[i])) {
                modules.addElement(args[++i]);
                continue;
            }
            if ("-impl".equals(args[i])) {
                pnutsImpl = args[++i];
                continue;
            }
            if ("-encoding".equals(args[i])) {
                encoding = args[++i];
                continue;
            }
            if ("-help".equals(args[i])) {
                Main.printHelp("pnutsc");
                System.exit(0);
                continue;
            }
            files.addElement(args[i]);
            dirs.addElement(base);
        }
        File dir = new File(dest);
        if (!dir.exists()) {
            System.err.println("Directory " + dest + " does not exist");
        }
        if (files.size() == 0) {
            Main.printHelp("pnutsc");
            return;
        }
        String[] fileArray = new String[files.size()];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = (String)files.elementAt(i);
        }
        String[] dirArray = new String[dirs.size()];
        for (int i = 0; i < dirArray.length; ++i) {
            dirArray[i] = (String)dirs.elementAt(i);
        }
        String[] moduleArray = new String[modules.size()];
        for (int i = 0; i < moduleArray.length; ++i) {
            moduleArray[i] = (String)modules.elementAt(i);
        }
        if (jar != null) {
            if (new File(jar).exists()) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ZipOutputStream zout = new ZipOutputStream(bout);
                ZipFile zfile = new ZipFile(jar);
                byte[] buf = new byte[512];
                Enumeration<? extends ZipEntry> e = zfile.entries();
                while (e.hasMoreElements()) {
                    int n;
                    ZipEntry entry = e.nextElement();
                    InputStream in = zfile.getInputStream(entry);
                    zout.putNextEntry((ZipEntry)entry.clone());
                    while ((n = in.read(buf)) != -1) {
                        zout.write(buf, 0, n);
                    }
                }
                compiler.compileToZip(zout, fileArray, dirArray, moduleArray, mainClassName, pnutsImpl, encoding);
                zout.finish();
                FileOutputStream fout = new FileOutputStream(jar);
                bout.writeTo(fout);
                fout.close();
            } else {
                ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(jar));
                compiler.compileToZip(zout, fileArray, dirArray, moduleArray, mainClassName, pnutsImpl, encoding);
                zout.close();
            }
        } else {
            compiler.compileToFile(dir, fileArray, dirArray, moduleArray, mainClassName, pnutsImpl, encoding);
        }
    }
}

