/*
 * Decompiled with CFR 0.152.
 */
package tratz.cmdline;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineOptions {
    private List<Option> mOptions = new ArrayList<Option>();

    public void addOption(String name, String type, String description) {
        this.mOptions.add(new Option(name, type, description));
    }

    public List<Option> getOptions() {
        return new ArrayList<Option>(this.mOptions);
    }

    public String getArgumentsDescriptionString() {
        StringBuilder buf = new StringBuilder();
        for (Option opt : this.mOptions) {
            buf.append(opt.getName() + "\t<" + opt.getType() + ">\t" + opt.getDescription()).append("\n");
        }
        return buf.toString();
    }

    public static class Option {
        private String mName;
        private String mType;
        private String mDescription;

        public Option(String name, String type, String description) {
            this.mName = name;
            this.mType = type;
            this.mDescription = description;
        }

        public String getName() {
            return this.mName;
        }

        public String getType() {
            return this.mType;
        }

        public String getDescription() {
            return this.mDescription;
        }
    }
}

