/*
 * Decompiled with CFR 0.152.
 */
package tratz.semantics.srl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tratz.parse.io.ConllxSentenceReader;
import tratz.parse.io.SentenceReader;
import tratz.parse.transform.VchTransformer;
import tratz.parse.types.Arc;
import tratz.parse.types.Parse;
import tratz.parse.types.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropBankConverter {
    public static boolean INCLUDE_ALL_KIDS = false;
    public static boolean INCLUDE_PARTMOD_KID = true;
    public static boolean INCLUDE_AMOD_KID = true;
    public static Set<String> SKIP_DEPS = new HashSet<String>(Arrays.asList("det", "vch", "dep", "cc", "appos", "amod", "parataxis", "preconj", "poss", "punct", "rcmod"));

    public static Map<PTBSentence, List<SemArc>> readPropBankSemanticArcs(File file, Map<String, List<PTBSentence>> fileToSentences) throws IOException {
        HashMap<PTBSentence, List<SemArc>> semArcsMap = new HashMap<PTBSentence, List<SemArc>>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        while ((line = reader.readLine()) != null) {
            String[] split = line.split("\\s+");
            String f = split[0];
            List<PTBSentence> sentences = fileToSentences.get(f = f.substring(f.lastIndexOf(47) + 1));
            if (sentences == null) {
                System.err.println("No sentences were read for: " + f + " so we are skipping a PropBank entry for it");
                continue;
            }
            PTBSentence sentence = sentences.get(Integer.parseInt(split[1]));
            ArrayList<SemArc> semArcs = (ArrayList<SemArc>)semArcsMap.get(sentence);
            if (semArcs == null) {
                semArcs = new ArrayList<SemArc>();
                semArcsMap.put(sentence, semArcs);
            }
            int headTokenIndex = Integer.parseInt(split[2]);
            ParseNode headNode = sentence.terminals.get(headTokenIndex);
            String annotator = split[3];
            String frame = split[4];
            String flags = split[5];
            for (int i = 6; i < split.length; ++i) {
                String[] starSplits;
                String arg = split[i];
                int dashIndex = split[i].indexOf(45);
                String type = split[i].substring(dashIndex + 1);
                String tokens = split[i].substring(0, dashIndex);
                for (String starSplit : starSplits = tokens.split("\\*")) {
                    for (String commaSplit : starSplit.split(",")) {
                        String[] colonSplit = commaSplit.split(":");
                        int tokenIndex = Integer.parseInt(colonSplit[0]);
                        int depth = Integer.parseInt(colonSplit[1]);
                        ParseNode childNode = sentence.terminals.get(tokenIndex);
                        if (childNode.type.equals("-NONE-") && (childNode.emptylessIndex <= headNode.emptylessIndex || tokens.contains("*"))) continue;
                        SemArc semArc = new SemArc(childNode.emptylessIndex, headNode.emptylessIndex, type, arg, frame);
                        semArcs.add(semArc);
                    }
                }
            }
        }
        reader.close();
        return semArcsMap;
    }

    public static void traverse(List<ParseNode> allTerminals, ParseNode node, IntHolder fullCounter, IntHolder nonEmptyCounter) {
        if (node.isTerminal()) {
            node.index = fullCounter.x++;
            node.emptylessIndex = nonEmptyCounter.x++;
            allTerminals.add(node);
            if (!node.type.equals("-NONE-")) {
                // empty if block
            }
        } else {
            for (ParseNode child : node.children) {
                PropBankConverter.traverse(allTerminals, child, fullCounter, nonEmptyCounter);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        File ptbMrgWsjDir = new File(args[0]);
        String propbankDatafile = args[1];
        String autoTaggedParseFiles = args[2];
        String outFile = args[3];
        File outputFile = new File(outFile);
        File outputFileParentDirectory = outputFile.getParentFile();
        if (!outputFileParentDirectory.exists()) {
            System.err.println("Attempting to create directory: " + outputFileParentDirectory.getAbsolutePath());
            outputFileParentDirectory.mkdirs();
        }
        System.err.println("Reading MRG files from: " + ptbMrgWsjDir.getAbsolutePath());
        List<File> files = PropBankConverter.collectFiles(new ArrayList<File>(), ptbMrgWsjDir);
        HashMap<String, List<PTBSentence>> fileToSentences = new HashMap<String, List<PTBSentence>>();
        int sentenceIndex = 0;
        ArrayList<PTBSentence> allConstituentSentences = new ArrayList<PTBSentence>();
        for (File file : files) {
            List<PTBSentence> sentences = PropBankConverter.readPtbSentences(file);
            for (PTBSentence sentence : sentences) {
                sentence.overallIndex = sentenceIndex++;
                PropBankConverter.traverse(sentence.terminals, sentence.root, new IntHolder(0), new IntHolder(0));
                allConstituentSentences.add(sentence);
            }
            fileToSentences.put(file.getName(), sentences);
        }
        Map<PTBSentence, List<SemArc>> sentenceToArcs = PropBankConverter.readPropBankSemanticArcs(new File(propbankDatafile), fileToSentences);
        ArrayList<Parse> allSentences = new ArrayList<Parse>();
        ConllxSentenceReader sreader = new ConllxSentenceReader();
        System.err.println(autoTaggedParseFiles);
        for (String autoTaggedFile : autoTaggedParseFiles.split(File.pathSeparator)) {
            System.err.println("Reading from: " + autoTaggedFile);
            allSentences.addAll(PropBankConverter.readDependencySentences(sreader, autoTaggedFile));
        }
        VchTransformer vchTransformer = new VchTransformer();
        int numUnattached = 0;
        PrintWriter writer = new PrintWriter(new FileWriter(outFile));
        int numDependencySentences = allSentences.size();
        for (int i = 0; i < numDependencySentences; ++i) {
            Token tok;
            int t;
            Parse parse = (Parse)allSentences.get(i);
            PTBSentence constituentSentence = (PTBSentence)allConstituentSentences.get(i);
            List<SemArc> semArcs = sentenceToArcs.get(constituentSentence);
            List<Token> tokens = parse.getSentence().getTokens();
            List[] tokenToArcs = parse.getDependentArcLists();
            Arc[] tokenToHead = parse.getHeadArcs();
            vchTransformer.performTransformation(parse);
            HashMap<Token, HashSet<Token>> tokenToTokenPlusVch = new HashMap<Token, HashSet<Token>>();
            for (Token t2 : tokens) {
                HashSet<Token> vch = new HashSet<Token>();
                tokenToTokenPlusVch.put(t2, vch);
                vch.add(t2);
                PropBankConverter.addAllVch(vch, t2, tokenToHead);
            }
            ArrayList unattached = new ArrayList();
            HashMap<Token, HashSet<SemArc>> tokenToSemArcs = new HashMap<Token, HashSet<SemArc>>();
            for (t = 0; t < tokens.size(); ++t) {
                tok = tokens.get(t);
                if (semArcs == null) continue;
                for (SemArc sarc : semArcs) {
                    List kids;
                    Arc arcHead = tokenToHead[tok.getIndex()];
                    if (sarc.mChildToken != t || sarc.mArgType.endsWith("INVERTED")) continue;
                    HashSet<SemArc> tokensSemArcs = (HashSet<SemArc>)tokenToSemArcs.get(tok);
                    if (tokensSemArcs == null) {
                        tokensSemArcs = new HashSet<SemArc>();
                        tokenToSemArcs.put(tok, tokensSemArcs);
                    }
                    if (sarc.mArgType.contains("rel")) {
                        tokensSemArcs.add(sarc);
                        continue;
                    }
                    boolean isDependent = false;
                    Token headToken = tokens.get(sarc.mHeadToken);
                    Set vchCluster = (Set)tokenToTokenPlusVch.get(headToken);
                    if ((INCLUDE_ALL_KIDS || INCLUDE_AMOD_KID || INCLUDE_PARTMOD_KID) && (kids = tokenToArcs[tok.getIndex()]) != null) {
                        for (Arc kid : kids) {
                            if (!INCLUDE_ALL_KIDS && (!kid.getDependency().equals("amod") || !INCLUDE_AMOD_KID) && (!kid.getDependency().equals("partmod") || !INCLUDE_PARTMOD_KID) || kid.getChild().getIndex() != sarc.mHeadToken + 1) continue;
                            isDependent = true;
                            if (kid.getDependency().matches("amod|partmod")) {
                                sarc.mArgType = sarc.mArgType + "-INVERTED";
                                int oldHead = sarc.mHeadToken;
                                sarc.mHeadToken = sarc.mChildToken;
                                sarc.mChildToken = oldHead;
                                Token child = tokens.get(sarc.mChildToken);
                                HashSet<SemArc> childsemarcs = (HashSet<SemArc>)tokenToSemArcs.get(child);
                                if (childsemarcs == null) {
                                    childsemarcs = new HashSet<SemArc>();
                                    tokenToSemArcs.put(child, childsemarcs);
                                }
                                childsemarcs.add(sarc);
                                continue;
                            }
                            tokensSemArcs.add(sarc);
                        }
                    }
                    boolean foundTrueHead = false;
                    if (!isDependent) {
                        block8: while (arcHead != null) {
                            List kids2;
                            Token head = arcHead.getHead();
                            if (vchCluster.contains(head)) {
                                HashSet<SemArc> headSemArcs = (HashSet<SemArc>)tokenToSemArcs.get(arcHead.getChild());
                                if (headSemArcs == null) {
                                    headSemArcs = new HashSet<SemArc>();
                                    tokenToSemArcs.put(arcHead.getChild(), headSemArcs);
                                }
                                headSemArcs.add(sarc);
                                sarc.mHeadToken = head.getIndex() - 1;
                                foundTrueHead = true;
                                break;
                            }
                            if ((INCLUDE_ALL_KIDS || INCLUDE_AMOD_KID || INCLUDE_PARTMOD_KID) && (kids2 = tokenToArcs[head.getIndex()]) != null) {
                                for (Arc kid : kids2) {
                                    if (!INCLUDE_ALL_KIDS && (!INCLUDE_AMOD_KID || !kid.getDependency().equals("amod")) && (!INCLUDE_PARTMOD_KID || !kid.getDependency().equals("partmod")) || kid.getChild().getIndex() != sarc.mHeadToken + 1) continue;
                                    isDependent = true;
                                    if (kid.getDependency().matches("amod|partmod")) {
                                        sarc.mArgType = sarc.mArgType + "-INVERTED";
                                        int oldHead = sarc.mHeadToken;
                                        sarc.mChildToken = oldHead;
                                        sarc.mHeadToken = head.getIndex() - 1;
                                        Token child = tokens.get(sarc.mChildToken);
                                        HashSet<SemArc> childsemarcs = (HashSet<SemArc>)tokenToSemArcs.get(child);
                                        if (childsemarcs == null) {
                                            childsemarcs = new HashSet<SemArc>();
                                            tokenToSemArcs.put(child, childsemarcs);
                                        }
                                        childsemarcs.add(sarc);
                                        break block8;
                                    }
                                    HashSet<SemArc> headSemArcs = (HashSet<SemArc>)tokenToSemArcs.get(head);
                                    if (headSemArcs == null) {
                                        headSemArcs = new HashSet<SemArc>();
                                        tokenToSemArcs.put(head, headSemArcs);
                                    }
                                    headSemArcs.add(sarc);
                                    break block8;
                                }
                            }
                            if (sarc.mArgType.endsWith(arcHead.getChild().getText().toLowerCase())) break;
                            arcHead = tokenToHead[head.getIndex()];
                        }
                    }
                    if (isDependent || foundTrueHead) continue;
                    sarc.mArgType = sarc.mArgType + "UNATTACHED";
                    ++numUnattached;
                }
            }
            for (t = 0; t < tokens.size(); ++t) {
                String dep;
                tok = tokens.get(t);
                Arc arcHead = tokenToHead[tok.getIndex()];
                Set ars = (Set)tokenToSemArcs.get(tok);
                Object semType = null;
                String string = dep = arcHead == null ? "ROOT" : arcHead.getDependency();
                if (semType != null) {
                    dep = semType;
                }
                writer.print(tok.getIndex() + "\t" + tok.getText() + "\t_\t" + tok.getPos() + "\t" + tok.getPos() + "\t_\t" + (arcHead == null ? "0" : Integer.valueOf(arcHead.getHead().getIndex())) + "\t" + dep + "\t_\t_\t");
                if (ars != null) {
                    ArrayList arsList = new ArrayList(ars);
                    Collections.sort(arsList);
                    HashMap<String, SemArc> predicateToSemArc = new HashMap<String, SemArc>();
                    ArrayList arcsToRemove = new ArrayList();
                    for (SemArc arc : arsList) {
                        SemArc currentArc;
                        if (!arc.mArgType.startsWith("ARG") || (currentArc = (SemArc)predicateToSemArc.get(arc.mHeadFrame)) != null) continue;
                        predicateToSemArc.put(arc.mHeadFrame, arc);
                    }
                    arsList.removeAll(arcsToRemove);
                    SemArc lastArc = null;
                    for (SemArc sarc : arsList) {
                        writer.print(sarc.mArgType + "->" + (sarc.mHeadToken + 1) + "|" + sarc.mPropBankFileEntry + "|" + sarc.mHeadFrame + "\t");
                        lastArc = sarc;
                    }
                }
                writer.println();
            }
            writer.println();
        }
        writer.close();
        System.err.println("Number unattached: " + numUnattached + " (most failures to attach are due to empty category nodes)");
    }

    private static void addAllVch(Set<Token> vchSet, Token t, Arc[] tokenToHead) {
        Arc headArc = tokenToHead[t.getIndex()];
        if (headArc != null && headArc.getDependency().equals("vch")) {
            vchSet.add(headArc.getHead());
            PropBankConverter.addAllVch(vchSet, headArc.getHead(), tokenToHead);
        }
    }

    public static List<Parse> readDependencySentences(SentenceReader sreader, String inputFile) throws IOException {
        ArrayList<Parse> parses = new ArrayList<Parse>();
        BufferedReader reader = new BufferedReader(new FileReader(inputFile));
        Parse parse = null;
        while ((parse = sreader.readSentence(reader)) != null) {
            parses.add(parse);
        }
        reader.close();
        return parses;
    }

    public static void printParse(ParseNode node, String indent) {
        System.err.println(indent + node.type + (node.text == null ? "" : "_" + node.text));
        for (ParseNode child : node.children) {
            PropBankConverter.printParse(child, indent + "   ");
        }
    }

    public static List<PTBSentence> readPtbSentences(File file) throws IOException {
        ArrayList<PTBSentence> sentences = new ArrayList<PTBSentence>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        PTBSentence sentence = null;
        while ((sentence = PropBankConverter.readPtbSentence(reader)) != null) {
            sentences.add(sentence);
        }
        reader.close();
        return sentences;
    }

    public static PTBSentence readPtbSentence(BufferedReader reader) throws IOException {
        int nextCharacter;
        PTBSentence sentence = null;
        ArrayList<Object> stack = new ArrayList<Object>();
        int CARRIAGE_RETURN = 10;
        int LINE_FEED = 13;
        StringBuilder buf = new StringBuilder();
        while ((nextCharacter = reader.read()) != -1) {
            if (nextCharacter == CARRIAGE_RETURN || nextCharacter == LINE_FEED) continue;
            if (nextCharacter == 40) {
                stack.add("(");
                if (stack.size() != 1) continue;
                stack.add("-ROOT-");
                continue;
            }
            if (nextCharacter == 41) {
                if (buf.length() > 0) {
                    stack.add(buf.toString());
                    buf.setLength(0);
                }
                int previousOpenParenIndex = -1;
                for (int i = stack.size() - 1; i >= 0; --i) {
                    Object token = stack.get(i);
                    if (!"(".equals(token)) continue;
                    previousOpenParenIndex = i;
                    break;
                }
                String type = (String)stack.get(previousOpenParenIndex + 1);
                ParseNode node = new ParseNode(type);
                for (int i = previousOpenParenIndex + 2; i < stack.size(); ++i) {
                    Object o = stack.get(i);
                    if (o instanceof ParseNode) {
                        node.children.add((ParseNode)o);
                        continue;
                    }
                    node.text = (String)o;
                }
                int stackSize = stack.size();
                for (int i = stackSize - 1; i >= stackSize - (stackSize - previousOpenParenIndex); --i) {
                    stack.remove(i);
                }
                stack.add(node);
                if (stack.size() != 1) continue;
                sentence = new PTBSentence();
                sentence.root = node;
                break;
            }
            if (nextCharacter == 32) {
                if (buf.length() == 0) continue;
                stack.add(buf.toString());
                buf.setLength(0);
                continue;
            }
            buf.append((char)nextCharacter);
        }
        reader.read();
        return sentence;
    }

    public static List<File> collectFiles(List<File> files, File dir) {
        Object[] filesInDir = dir.listFiles();
        Arrays.sort(filesInDir);
        for (Object f : filesInDir) {
            if (((File)f).isDirectory()) {
                if (((File)f).getName().equals("00") || ((File)f).getName().equals("01")) {
                    System.err.println("Hard-coded to skip: " + ((File)f).getName());
                    continue;
                }
                PropBankConverter.collectFiles(files, (File)f);
                continue;
            }
            files.add((File)f);
        }
        return files;
    }

    public static boolean hasAux(Token token, List[] arcLists) {
        boolean hasAux = false;
        List arcList = arcLists[token.getIndex()];
        if (arcList != null) {
            for (Arc arc : arcList) {
                if (!arc.getDependency().startsWith("aux")) continue;
                hasAux = true;
            }
        }
        return hasAux;
    }

    public static boolean hasNoArgArcs(Set<SemArc> ars) {
        if (ars == null) {
            return true;
        }
        boolean hasNoArgArcs = true;
        for (SemArc arc : ars) {
            if (!arc.mArgType.startsWith("ARG")) continue;
            hasNoArgArcs = false;
            break;
        }
        return hasNoArgArcs;
    }

    public static boolean hasDep(String dep, String markText, List<Arc> children) {
        if (children == null) {
            return false;
        }
        boolean hasNoArgArcs = false;
        for (Arc arc : children) {
            if (!arc.getDependency().equals(dep) || markText != null && !arc.getChild().getText().toLowerCase().equals(markText)) continue;
            hasNoArgArcs = true;
            break;
        }
        return hasNoArgArcs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SemArc
    implements Comparable<SemArc> {
        private int mChildToken;
        private int mHeadToken;
        private String mArgType;
        private String mPropBankFileEntry;
        private String mHeadFrame;
        private String s;

        public SemArc(int childToken, int headToken, String argType, String fullEntry, String headFrame) {
            this.mHeadToken = headToken;
            this.mChildToken = childToken;
            this.mArgType = argType;
            this.mPropBankFileEntry = fullEntry;
            this.mHeadFrame = headFrame;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object a2) {
            return this.toString().equals(a2.toString());
        }

        public String toString() {
            if (this.s == null) {
                this.s = this.mArgType + ":" + this.mPropBankFileEntry + ":" + this.mHeadFrame;
            }
            return this.s;
        }

        @Override
        public int compareTo(SemArc a2) {
            return this.toString().compareTo(a2.toString());
        }
    }

    public static class IntHolder {
        public int x;

        public IntHolder(int val) {
            this.x = val;
        }
    }

    public static class PTBSentence {
        int overallIndex = -1;
        List<ParseNode> terminals = new ArrayList<ParseNode>();
        ParseNode root;
    }

    public static class ParseNode {
        List<ParseNode> children = new ArrayList<ParseNode>();
        int index;
        int emptylessIndex;
        String type;
        String text;

        public ParseNode(String type) {
            this.type = type;
        }

        public boolean isTerminal() {
            return this.children.size() == 0;
        }

        public String toString() {
            return this.type;
        }
    }
}

