/*
 * Decompiled with CFR 0.152.
 */
package tratz.semantics.psd.training;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tratz.featgen.MultiStepFeatureGeneratorConfigParser;
import tratz.featgen.WfrEntry;
import tratz.featgen.fer.FeatureExtractionRule;
import tratz.parse.types.Arc;
import tratz.parse.types.Parse;
import tratz.runpipe.Annotation;
import tratz.runpipe.InitializationException;
import tratz.runpipe.ProcessException;
import tratz.runpipe.TextDocument;
import tratz.runpipe.annotations.Sentence;
import tratz.runpipe.annotations.Token;
import tratz.runpipe.impl.EndPointImpl;
import tratz.runpipe.util.RunpipeUtils;
import tratz.semantics.psd.training.HeadAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureExtractorEndPoint
extends EndPointImpl {
    public static final String PARAM_OUTPUT_DIR = "OutputDir";
    public static final String PARAM_COMPLEX_RULE_LIST = "ComplexRuleList";
    public static final String PARAM_FEATURE_EXTRACTION_LIST = "FeatureExtractionRuleList";
    public static final String PARAM_COMBO_RULE_LIST = "ComboRuleList";
    public static final String PARAM_TRUTH_DIR = "TruthDir";
    public static final String PARAM_OVERRIDE_MAP_FILE = "OverrideMap";
    public static final String PARAM_APPEND = "Append";
    private WfrEntry[] mComplexRules;
    private File mOutDir;
    private Map<String, FeatureExtractionRule> mFeatureRuleMap;
    private Map<String, String> mTruthMap;
    private boolean mAppend;
    private boolean mOverridden;

    @Override
    public void initialize(Map<String, String> params) throws InitializationException {
        this.mOutDir = new File(params.get(PARAM_OUTPUT_DIR));
        String featureExtractionRuleList = params.get(PARAM_FEATURE_EXTRACTION_LIST);
        String complexRuleListFile = params.get(PARAM_COMPLEX_RULE_LIST);
        String comboRuleList = params.get(PARAM_COMBO_RULE_LIST);
        String truthDir = params.get(PARAM_TRUTH_DIR);
        this.mAppend = Boolean.parseBoolean(params.get(PARAM_APPEND));
        try {
            MultiStepFeatureGeneratorConfigParser configReader = new MultiStepFeatureGeneratorConfigParser();
            this.mFeatureRuleMap = configReader.readFeatureExtractionRuleMap(featureExtractionRuleList);
            this.mComplexRules = configReader.readComplexRules(complexRuleListFile, this.mFeatureRuleMap);
            this.mTruthMap = new HashMap<String, String>();
            FeatureExtractorEndPoint.readTruthMap(new File(truthDir), this.mTruthMap, null);
            String overrideMap = params.get(PARAM_OVERRIDE_MAP_FILE);
            if (overrideMap != null) {
                this.mTruthMap = new HashMap<String, String>();
                FeatureExtractorEndPoint.readNewTruthMap(new File(overrideMap), this.mTruthMap);
                this.mOverridden = true;
            }
        }
        catch (Exception ioe) {
            throw new InitializationException(ioe);
        }
    }

    private static void readTruthMap(File truthDir, Map<String, String> truthMap, Map<String, String> senseToSrType) throws IOException {
        File[] files;
        for (File file : files = truthDir.listFiles()) {
            if (!file.getName().endsWith("key")) continue;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                String[] split = line.split("\\s+");
                String className = split[2];
                truthMap.put(split[1], className);
            }
            reader.close();
        }
    }

    public static void readNewTruthMap(File newTruthFile, Map<String, String> truthMap) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(newTruthFile));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).startsWith("#")) continue;
            String[] parts = line.split("\\t+");
            truthMap.put(parts[0], parts[1]);
        }
        reader.close();
    }

    @Override
    public void process(TextDocument doc) throws ProcessException {
        List<? extends Annotation> heads = doc.getAnnotationList(HeadAnnotation.class);
        List<? extends Annotation> tokenList = doc.getAnnotationList(Token.class);
        if (!this.mOutDir.exists()) {
            this.mOutDir.mkdirs();
        }
        PrintWriter writer = null;
        try {
            String uri = doc.getUri();
            String inputFilename = uri.substring(uri.lastIndexOf(47) + 1);
            String preposition = inputFilename.substring(3, inputFilename.indexOf(46));
            File newFile = new File(this.mOutDir, preposition);
            System.err.println("New file: " + newFile.getName());
            writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(newFile, this.mAppend)));
            List<? extends Annotation> sentences = doc.getAnnotationList(Sentence.class);
            if (sentences != null) {
                String originalString = null;
                String sentenceText = null;
                String parseString = null;
                HeadAnnotation head = null;
                for (Sentence sentence : sentences) {
                    List<? extends Annotation> containedList = RunpipeUtils.getSublist(sentence, tokenList);
                    for (HeadAnnotation headAnnotation : heads) {
                        if (headAnnotation.getStart() < sentence.getStart() || headAnnotation.getEnd() > sentence.getEnd()) continue;
                        head = headAnnotation;
                        ArrayList annotSets = new ArrayList();
                        HashMap<WfrEntry, List<Set<tratz.parse.types.Token>>> ruleToAnnotSets = new HashMap<WfrEntry, List<Set<tratz.parse.types.Token>>>();
                        sentenceText = sentence.getAnnotText();
                        parseString = sentence.getParseString();
                        int numTokens = containedList.size();
                        int headIndex = -1;
                        for (int i = 0; i < numTokens; ++i) {
                            if (headAnnotation.getEnd() != ((Token)containedList.get(i)).getEnd()) continue;
                            headIndex = i;
                        }
                        ArrayList<tratz.parse.types.Token> parserTokens = new ArrayList<tratz.parse.types.Token>();
                        for (int i = 0; i < containedList.size(); ++i) {
                            Token token = (Token)containedList.get(i);
                            parserTokens.add(new tratz.parse.types.Token(token.getAnnotText(), token.getPos(), i + 1));
                        }
                        ArrayList<Arc> arcs = new ArrayList<Arc>();
                        for (int i = 0; i < containedList.size(); ++i) {
                            Token headTok;
                            tratz.parse.types.Token t = (tratz.parse.types.Token)parserTokens.get(i);
                            Token tok = (Token)containedList.get(i);
                            Token.Arc headTokParent = tok.getParentArc();
                            if (headTokParent == null || (headTok = headTokParent.getHead()) == null) continue;
                            String depend = headTokParent.getDependency();
                            int parentIndex = containedList.indexOf(headTok);
                            tratz.parse.types.Token normalHead = (tratz.parse.types.Token)parserTokens.get(parentIndex);
                            arcs.add(new Arc(t, normalHead, depend));
                        }
                        tratz.parse.types.Sentence parsedSentence = new tratz.parse.types.Sentence(parserTokens);
                        Parse parse = new Parse(parsedSentence, null, arcs);
                        for (WfrEntry rule : this.mComplexRules) {
                            Set<tratz.parse.types.Token> annotations = rule.getWfrRule().getProductions(parserTokens, parse, headIndex);
                            if (annotations == null || annotations.size() <= 0) continue;
                            ArrayList<Set<tratz.parse.types.Token>> list = new ArrayList<Set<tratz.parse.types.Token>>();
                            list.add(annotations);
                            ruleToAnnotSets.put(rule, list);
                        }
                        if (head != null) {
                            String sense = head.getSenseId();
                            if (this.mTruthMap.containsKey(headAnnotation.getId()) && (sense = this.mTruthMap.get(headAnnotation.getId())).trim().equals("")) {
                                System.err.println("Warning: Unexpected whitespace-only or empty string class name for instance: " + headAnnotation.getId());
                            }
                            if (sense == null || sense.equals("-1") || this.mOverridden && !this.mTruthMap.containsKey(headAnnotation.getId())) continue;
                            this.writeFeatures(writer, originalString, sentenceText, parseString, head, sense, ruleToAnnotSets, sentence, tokenList);
                            continue;
                        }
                        System.err.println("ERROR: head not found");
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ProcessException(e);
        }
        writer.close();
    }

    private void writeFeatures(PrintWriter writer, String originalString, String sentenceText, String parseString, HeadAnnotation headAnnot, String sense, Map<WfrEntry, List<Set<tratz.parse.types.Token>>> ruleToAnnotSets, Sentence sentence, List<Token> tokens) throws Exception {
        writer.print(headAnnot.getId() + "\u0018" + sense + "\u0018");
        ArrayList<WfrEntry> allRules = new ArrayList<WfrEntry>();
        allRules.addAll(Arrays.asList(this.mComplexRules));
        List<Token> tokenList = RunpipeUtils.getSublist(sentence, tokens);
        boolean foundHead = false;
        for (Token t : tokenList) {
            if (t.getStart() != headAnnot.getStart() || t.getEnd() != headAnnot.getEnd()) continue;
            foundHead = true;
        }
        if (!foundHead) {
            System.err.println("ERROR: !Failed to find head for: " + headAnnot.getId());
        }
        HashSet<String> feats = new HashSet<String>();
        for (WfrEntry rule : allRules) {
            List<Set<tratz.parse.types.Token>> annotSetList = ruleToAnnotSets.get(rule);
            if (annotSetList == null || annotSetList.size() <= 0) continue;
            for (int i = 0; i < annotSetList.size(); ++i) {
                ArrayList annots = new ArrayList(annotSetList.get(i));
                int numAnnots = annots.size();
                for (int j = 0; j < numAnnots; ++j) {
                    String[] parts;
                    String lastPart;
                    int periodIndex;
                    tratz.parse.types.Token annot = (tratz.parse.types.Token)annots.get(j);
                    String annotText = annot.getText();
                    String type = annot.getPos();
                    if (type == null) {
                        System.err.println("Null type for: " + annotText);
                    }
                    if ((periodIndex = (lastPart = (parts = annotText.split("\\s+"))[parts.length - 1]).indexOf(46)) == lastPart.length() - 1 && periodIndex != 0) {
                        annotText = annotText.substring(0, periodIndex);
                    }
                    List<FeatureExtractionRule> fers = rule.getFERs();
                    for (FeatureExtractionRule fer : fers) {
                        Set<String> productions = fer.getProductions(annotText, type);
                        if (productions == null) continue;
                        for (String production : productions) {
                            production = production.replace("\u0018", "*c*");
                            feats.add((rule.getPrefix() + ":" + fer.getPrefix() + ":" + production).toLowerCase());
                        }
                    }
                }
            }
        }
        ArrayList featList = new ArrayList(feats);
        Collections.sort(featList);
        int numFeats = featList.size();
        for (int i = 0; i < numFeats; ++i) {
            String feati = (String)featList.get(i);
            writer.print(feati);
            writer.print("\u0018");
        }
        writer.println();
    }

    @Override
    public void batchFinished() {
    }
}

