/*
 * Decompiled with CFR 0.152.
 */
package Jet.Refres;

import Jet.Control;
import Jet.JetTest;
import Jet.Refres.CorefFilter;
import Jet.Refres.DocumentScorer;
import Jet.Refres.EntityView;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.AnnotationColor;
import Jet.Tipster.Document;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.View;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public class CorefScorer
extends DocumentScorer {
    private Document responseDoc;
    private Document keyDoc;
    private HashMap responseToKeyMentionMap;
    private HashMap keyToResponseMentionMap;
    private Vector responseEntities;
    private Vector keyEntities;
    private HashMap responseMentionToEntityMap;
    private HashMap keyMentionToEntityMap;
    public float recall;
    public float precision;
    public float overallRecall;
    public float overallPrecision;
    public int mappedMentionCount = 0;
    public int overallMappedMentionCount = 0;
    private int recallNumerator = 0;
    private int recallDenominator = 0;
    private int precisionNumerator = 0;
    private int precisionDenominator = 0;
    private int scoreNumerator;
    private int scoreDenominator;

    public void score(Document document, Document document2) {
        this.responseDoc = document;
        this.keyDoc = document2;
        this.mappedMentionCount = 0;
        this.alignMentions();
        this.responseEntities = document.annotationsOfType("entity");
        if (this.responseEntities == null) {
            System.err.println("CorefScorer.score:  no entity annotations in response");
            return;
        }
        this.keyEntities = document2.annotationsOfType("entity");
        if (this.keyEntities == null) {
            System.err.println("CorefScorer.score:  no entity annotations in key");
            return;
        }
        this.responseMentionToEntityMap = this.buildMentionToEntityMap(document, this.responseEntities);
        this.keyMentionToEntityMap = this.buildMentionToEntityMap(document2, this.keyEntities);
        this.precision = this.scoreEntities(this.responseEntities, this.responseToKeyMentionMap, this.keyMentionToEntityMap, true);
        this.recall = this.scoreEntities(this.keyEntities, this.keyToResponseMentionMap, this.responseMentionToEntityMap, false);
        this.overallPrecision = (float)this.precisionNumerator / (float)this.precisionDenominator;
        this.overallRecall = (float)this.recallNumerator / (float)this.recallDenominator;
        this.overallMappedMentionCount += this.mappedMentionCount;
    }

    private void alignMentions() {
        HashMap hashMap = CorefScorer.buildEndOfMentionMap(this.keyDoc);
        this.responseToKeyMentionMap = new HashMap();
        this.keyToResponseMentionMap = new HashMap();
        Vector vector = CorefScorer.findMentions(this.responseDoc);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Annotation annotation = (Annotation)vector.elementAt(i);
                Annotation annotation2 = Resolve.getHeadC(annotation);
                int n = annotation2.span().end();
                Annotation annotation3 = (Annotation)hashMap.get(new Integer(n));
                if (annotation3 == null) continue;
                this.responseToKeyMentionMap.put(annotation, annotation3);
                this.keyToResponseMentionMap.put(annotation3, annotation);
                ++this.mappedMentionCount;
            }
        }
    }

    static HashMap buildEndOfMentionMap(Document document) {
        HashMap<Integer, Annotation> hashMap = new HashMap<Integer, Annotation>();
        Vector vector = CorefScorer.findMentions(document);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Annotation annotation = (Annotation)vector.elementAt(i);
                Annotation annotation2 = Resolve.getHeadC(annotation);
                int n = annotation2.span().end();
                hashMap.put(new Integer(n), annotation);
            }
        }
        return hashMap;
    }

    public static Vector findMentions(Document document) {
        Vector vector = new Vector();
        Vector<Annotation> vector2 = document.annotationsOfType("entity");
        if (vector2 != null) {
            for (int i = 0; i < vector2.size(); ++i) {
                Annotation annotation = vector2.get(i);
                Vector vector3 = (Vector)annotation.get("mentions");
                vector.addAll(vector3);
            }
        }
        return vector;
    }

    private HashMap buildMentionToEntityMap(Document document, Vector vector) {
        HashMap<Annotation, Annotation> hashMap = new HashMap<Annotation, Annotation>();
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = (Annotation)vector.get(i);
            Vector vector2 = (Vector)annotation.get("mentions");
            if (vector2 == null) {
                System.err.println("(buildMentionToEntityMap) entity with no mentions");
                return null;
            }
            for (int j = 0; j < vector2.size(); ++j) {
                Annotation annotation2 = (Annotation)vector2.get(j);
                hashMap.put(annotation2, annotation);
            }
        }
        return hashMap;
    }

    private float scoreEntities(Vector vector, HashMap hashMap, HashMap hashMap2, boolean bl) {
        this.scoreNumerator = 0;
        this.scoreDenominator = 0;
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = (Annotation)vector.get(i);
            this.scoreEntity(annotation, hashMap, hashMap2);
        }
        if (bl) {
            this.precisionNumerator += this.scoreNumerator;
            this.precisionDenominator += this.scoreDenominator;
        } else {
            this.recallNumerator += this.scoreNumerator;
            this.recallDenominator += this.scoreDenominator;
        }
        return (float)this.scoreNumerator / (float)this.scoreDenominator;
    }

    private void scoreEntity(Annotation annotation, HashMap hashMap, HashMap hashMap2) {
        Vector vector = (Vector)annotation.get("mentions");
        int n = 0;
        int n2 = 0;
        HashSet<Annotation> hashSet = new HashSet<Annotation>();
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation2 = (Annotation)vector.get(i);
            Annotation annotation3 = (Annotation)hashMap.get(annotation2);
            if (annotation3 == null) {
                ++n;
                continue;
            }
            ++n2;
            Annotation annotation4 = (Annotation)hashMap2.get(annotation3);
            hashSet.add(annotation4);
        }
        if (n2 > 0) {
            this.scoreNumerator += n2 - hashSet.size();
            this.scoreDenominator += n2 - 1;
        }
    }

    public void report() {
        System.out.println("Recall = " + this.recall);
        System.out.println("Precision = " + this.precision);
        System.out.println(this.mappedMentionCount + " mapped mentions");
    }

    public void summary() {
        System.out.println("");
        System.out.println("Overall Recall = " + this.overallRecall);
        System.out.println("Overall Precision = " + this.overallPrecision);
        float f = 2.0f / (1.0f / this.overallRecall + 1.0f / this.overallPrecision);
        System.out.println("F = " + f);
        System.out.println(this.overallMappedMentionCount + " total mapped mentions");
    }

    public static void main(String[] stringArray) throws IOException {
        String string = System.getProperty("user.home") + "\\";
        new AnnotationColor(string + "My Documents\\Jet");
        String string2 = string + "My Documents\\Jet\\Data\\coref.txt";
        String[] stringArray2 = new String[]{"coref"};
        ExternalDocument externalDocument = new ExternalDocument("sgml", string2);
        externalDocument.setSGMLtags(stringArray2);
        externalDocument.open();
        CorefFilter.buildEntitiesFromLinkedMentions(externalDocument);
        new View(externalDocument, 0);
        new EntityView(externalDocument, 1);
        JetTest.initializeFromConfig("chunk3.properties");
        String string3 = string + "My Documents\\Jet\\Data\\article.txt";
        Document document = JetTest.readDocument(new BufferedReader(new FileReader(string3)));
        Control.processDocument(document, null, true, 1);
        new EntityView(document, 2);
        CorefScorer corefScorer = new CorefScorer();
        corefScorer.score(document, externalDocument);
        System.out.println("Recall = " + corefScorer.recall);
        System.out.println("Precision = " + corefScorer.precision);
    }
}

