/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse.types;

import java.io.Serializable;
import tratz.parse.types.Token;

public class Arc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Token mChild;
    private Token mHead;
    private String mDependency;
    private int mCreationNum;
    private String mSemanticAnnotation;

    public Arc(Token child, Token head, String type) {
        this(child, head, type, -1);
    }

    public Arc(Token child, Token head, String type, int creationNumber) {
        this.mChild = child;
        this.mHead = head;
        this.mDependency = type;
        this.mCreationNum = creationNumber;
    }

    public String getDependency() {
        return this.mDependency;
    }

    public void setDependency(String dep) {
        this.mDependency = dep;
    }

    public void setSemanticAnnotation(String semanticAnnotation) {
        this.mSemanticAnnotation = semanticAnnotation;
    }

    public String getSemanticAnnotation() {
        return this.mSemanticAnnotation;
    }

    public Token getChild() {
        return this.mChild;
    }

    public void setChild(Token newChild) {
        this.mChild = newChild;
    }

    public Token getHead() {
        return this.mHead;
    }

    public void setHead(Token newHead) {
        this.mHead = newHead;
    }

    public void setCreationNum(int creationNum) {
        this.mCreationNum = creationNum;
    }

    public int getCreationNum() {
        return this.mCreationNum;
    }

    public boolean equals(Arc arc) {
        return this.mChild.getIndex() == arc.mChild.getIndex() && this.mHead.getIndex() == arc.mHead.getIndex() && this.mDependency.equals(arc.mDependency);
    }
}

