/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import tratz.featgen.MultiStepFeatureGenerator;
import tratz.jwni.WordNet;
import tratz.ml.ClassScoreTuple;
import tratz.ml.LinearClassificationModel;
import tratz.parse.NLParser;
import tratz.parse.featgen.ParseFeatureGenerator;
import tratz.parse.ml.ParseModel;
import tratz.parse.types.Arc;
import tratz.parse.types.Parse;
import tratz.parse.types.Sentence;
import tratz.parse.types.Token;
import tratz.pos.featgen.PosFeatureGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserGui
extends JFrame {
    private static final Dimension DEFAULT_SIZE = new Dimension(500, 500);
    private JButton mParseButton = new JButton("Parse");
    private JButton mParseAndDisplay = new JButton("Display");
    private JButton mClear = new JButton("Clear");
    private JPanel mRightPanel = new JPanel(new GridBagLayout());
    private JPanel mLeftPanel = new JPanel(new BorderLayout());
    private JTextField mInputField = new JTextField();
    private JTextArea mOutputArea = new JTextArea();
    private JScrollPane mScrollPane = new JScrollPane(this.mOutputArea);
    private List<String> mHistory = new ArrayList<String>();
    private int mHistoryIndex = 0;
    private PosFeatureGenerator mFeatGen;
    private LinearClassificationModel mDecMaker;
    private NLParser mParser;
    private MultiStepFeatureGenerator mPsdFeatGen;
    private MultiStepFeatureGenerator mNNFeatGen;
    private Map<String, LinearClassificationModel> mPrepModels;

    public ParserGui(NLParser parser, PosFeatureGenerator featGen, LinearClassificationModel decMaker, MultiStepFeatureGenerator psdFeatGenerator, MultiStepFeatureGenerator nnFeatGenerator, Map<String, LinearClassificationModel> prepModels) {
        this.mParser = parser;
        this.mFeatGen = featGen;
        this.mDecMaker = decMaker;
        this.mPsdFeatGen = psdFeatGenerator;
        this.mNNFeatGen = nnFeatGenerator;
        this.mPrepModels = prepModels;
        this.setDefaultCloseOperation(3);
        this.setSize(DEFAULT_SIZE);
        this.setTitle("Parser GUI");
        this.createLayout();
        this.createListeners();
        this.mInputField.setFont(new Font(this.mInputField.getFont().getName(), 0, 16));
        this.mOutputArea.setFont(new Font(this.mOutputArea.getFont().getName(), 0, 16));
    }

    private void createLayout() {
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.mLeftPanel, "Center");
        contentPane.add((Component)this.mRightPanel, "East");
        this.mLeftPanel.add((Component)this.mInputField, "North");
        this.mLeftPanel.add((Component)this.mScrollPane, "Center");
        this.mRightPanel.add((Component)this.mParseButton, new GridBagConstraints(0, 0, 1, 1, 100.0, 0.0, 10, 2, new Insets(30, 5, 5, 5), 0, 0));
        this.mRightPanel.add((Component)this.mParseAndDisplay, new GridBagConstraints(0, 1, 1, 1, 100.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.mRightPanel.add((Component)this.mClear, new GridBagConstraints(0, 2, 1, 1, 100.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.mRightPanel.add((Component)new JPanel(), new GridBagConstraints(0, 3, 1, 1, 100.0, 100.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void createListeners() {
        this.mInputField.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38) {
                    ParserGui.this.mHistoryIndex++;
                    if (ParserGui.this.mHistoryIndex < ParserGui.this.mHistory.size()) {
                        ParserGui.this.mInputField.setText((String)ParserGui.this.mHistory.get(ParserGui.this.mHistoryIndex));
                    } else {
                        ParserGui.this.mHistoryIndex = ParserGui.this.mHistory.size() - 2;
                    }
                } else if (e.getKeyCode() == 40) {
                    ParserGui.this.mHistoryIndex--;
                    if (ParserGui.this.mHistoryIndex > 0 && ParserGui.this.mHistoryIndex < ParserGui.this.mHistory.size()) {
                        ParserGui.this.mInputField.setText((String)ParserGui.this.mHistory.get(ParserGui.this.mHistoryIndex));
                    } else {
                        ParserGui.this.mHistoryIndex = 0;
                        ParserGui.this.mInputField.setText("");
                    }
                }
            }
        });
        this.mInputField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParserGui.this.parseAction(e);
            }
        });
        this.mParseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParserGui.this.parseAction(e);
            }
        });
        this.mParseAndDisplay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParserGui.this.mParseAndDisplay_actionPerformed(e);
            }
        });
        this.mClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParserGui.this.mClear_actionPerformed(e);
            }
        });
    }

    private void parseAction(ActionEvent e) {
        try {
            String text = this.mInputField.getText();
            if (!text.trim().equals("")) {
                String[] tokenized = text.split("\\s+");
                ArrayList<Token> tokens = new ArrayList<Token>();
                int index = 1;
                for (String s : tokenized) {
                    tokens.add(new Token(s, index++));
                }
                this.posTag(tokens);
                Parse parse = this.mParser.parseSentence(new Sentence(tokens));
                List[] tokenToArcs = parse.getDependentArcLists();
                Arc[] tokenToHead = parse.getHeadArcs();
                this.performPrepositionDisambiguation(tokens, parse);
                String outputString = this.createOutputString(tokens, parse);
                this.mOutputArea.setText(this.mOutputArea.getText() + outputString);
                this.mHistory.add(0, text);
                this.mHistoryIndex = -1;
            }
            this.mInputField.setText("");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void mParseAndDisplay_actionPerformed(ActionEvent e) {
        try {
            String outfilename = "monkey.png";
            String text = this.mInputField.getText();
            if (!text.trim().equals("")) {
                List<Token> tokens = this.createTokens(text);
                this.posTag(tokens);
                Parse parse = this.mParser.parseSentence(new Sentence(tokens));
                String outputString = this.createOutputString(tokens, parse);
                this.mOutputArea.setText(this.mOutputArea.getText() + outputString);
                this.mHistory.add(0, text);
                this.mHistoryIndex = -1;
                ParserGui.createImage(parse, outfilename, true);
                Runtime runtime = Runtime.getRuntime();
                runtime.exec(new String[]{"eog", outfilename});
            }
            this.mInputField.setText("");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private List<Token> createTokens(String text) {
        String[] tokenized = text.split("\\s+");
        ArrayList<Token> tokens = new ArrayList<Token>(tokenized.length);
        int index = 1;
        for (String s : tokenized) {
            tokens.add(new Token(s, index++));
        }
        return tokens;
    }

    private void posTag(List<Token> tokens) {
        int numTokens = tokens.size();
        for (int j = 0; j < numTokens; ++j) {
            Set<String> feats = this.mFeatGen.getFeats(tokens, j);
            ClassScoreTuple[] classRankings = this.mDecMaker.getDecision(feats);
            Token t = tokens.get(j);
            t.setPos(classRankings[0].clazz);
        }
    }

    private void performPrepositionDisambiguation(List<Token> tokens, Parse parse) {
        for (Arc arc : parse.getHeadArcs()) {
            LinearClassificationModel prepModel;
            if (arc == null || !"prep".equals(arc.getDependency()) || (prepModel = this.mPrepModels.get(arc.getChild().getText().toLowerCase())) == null) continue;
            Set<String> feats = this.mPsdFeatGen.generateFeatures(tokens, parse, arc.getChild().getIndex() - 1);
            ClassScoreTuple[] rankings = prepModel.getDecision(feats);
            arc.getChild().setLexSense(rankings[0].clazz);
        }
    }

    private String createOutputString(List<Token> tokens, Parse parse) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        for (Token t : tokens) {
            Arc arc = parse.getHeadArcs()[i + 1];
            buf.append(i + 1).append('\t').append(t.getText());
            buf.append('\t');
            buf.append(t.getPos());
            buf.append('\t');
            buf.append(arc == null || arc.getHead().getPos() == null ? 0 : arc.getHead().getIndex());
            buf.append('\t');
            buf.append(arc == null || arc.getHead().getPos() == null ? "ROOT" : arc.getDependency());
            buf.append("\t" + t.getLexSense());
            buf.append("\n");
            ++i;
        }
        buf.append("\n");
        return buf.toString();
    }

    private void mClear_actionPerformed(ActionEvent e) {
        this.mOutputArea.setText("");
        this.mHistoryIndex = 0;
    }

    public static void createImage(Parse parse, String outfilename, boolean includeRoot) throws IOException, InterruptedException {
        File tmp = File.createTempFile("pref", "suff");
        PrintWriter writer = new PrintWriter(new FileWriter(tmp));
        writer.println("digraph G {");
        if (includeRoot) {
            writer.println("node_0 [label=\"[ROOT]\",style=rounded,shape=box];");
        }
        for (Token t : parse.getSentence().getTokens()) {
            writer.println("node_" + t.getIndex() + " [label=\"" + t.getText().replace("\"", "\\\"") + "\",style=rounded,shape=box,margin=\"0.055,0.027\",width=\"0.01\",height=\"0.01\",color=\"" + (t.getPos().startsWith("VB") ? "red" : "darkturquoise") + "\"];");
        }
        for (Token t : parse.getSentence().getTokens()) {
            Arc a = parse.getHeadArcs()[t.getIndex()];
            Token parent = parse.getHeadArcs()[a.getChild().getIndex()].getHead();
            if (parent == null || !includeRoot && parent.getIndex() <= 0) continue;
            writer.println("node_" + parent.getIndex() + " -> node_" + a.getChild().getIndex() + " [label=\"" + a.getDependency() + "\"];");
        }
        writer.println("}");
        writer.close();
        System.err.println("Wrote to: " + tmp.getAbsolutePath());
        Runtime runtime = Runtime.getRuntime();
        Process p = runtime.exec(new String[]{"dot", "-Tpng", "-o" + outfilename, tmp.getAbsolutePath()});
        p.waitFor();
        tmp.delete();
    }

    public static void main(String[] args) throws Exception {
        String wnDir = args[0];
        String posModel = args[1];
        String modelFile = args[2];
        final MultiStepFeatureGenerator nnFeatureExtractor = null;
        final MultiStepFeatureGenerator psdFeatGen = null;
        final HashMap prepModels = new HashMap();
        System.err.print("Loading pos tagging model...");
        ObjectInputStream ois1 = new ObjectInputStream(new GZIPInputStream(new FileInputStream(posModel)));
        final LinearClassificationModel posTaggingDecisionModule = (LinearClassificationModel)ois1.readObject();
        final PosFeatureGenerator posTaggingFeatureGenerator = (PosFeatureGenerator)ois1.readObject();
        ois1.close();
        System.err.println("loaded");
        System.err.print("Loading parsing model...");
        long startTime = System.currentTimeMillis();
        FilterInputStream is = new BufferedInputStream(new FileInputStream(modelFile));
        if (modelFile.endsWith(".gz")) {
            is = new GZIPInputStream(is);
        }
        ObjectInputStream ois = new ObjectInputStream(is);
        ParseModel model = (ParseModel)ois.readObject();
        ParseFeatureGenerator featGen = (ParseFeatureGenerator)ois.readObject();
        ois.close();
        System.gc();
        System.err.println("loaded");
        System.err.println("Parse model loading took: " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds.");
        new WordNet(new File(wnDir));
        final NLParser parser = new NLParser(model, featGen);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ParserGui gui = new ParserGui(parser, posTaggingFeatureGenerator, posTaggingDecisionModule, psdFeatGen, nnFeatureExtractor, prepModels);
                gui.setVisible(true);
            }
        });
    }
}

