/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.DictionaryElement;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.dictionary.Dictionary;

public class IndexWord
implements DictionaryElement {
    static final long serialVersionUID = -2136983562978852712L;
    private POS _pos;
    private String _lemma;
    private long[] _synsetOffsets;
    private transient Synset[] _synsets;
    private transient boolean _synsetsLoaded = false;
    private transient String _cachedToString = null;

    public IndexWord(String string, POS pOS, long[] lArray) {
        this._lemma = string;
        this._pos = pOS;
        this._synsetOffsets = lArray;
        this._synsets = new Synset[lArray.length];
    }

    public boolean equals(Object object) {
        return object instanceof IndexWord && ((IndexWord)object).getLemma().equals(this.getLemma()) && ((IndexWord)object).getPOS().equals(this.getPOS());
    }

    public int hashCode() {
        return this.getLemma().hashCode() ^ this.getPOS().hashCode();
    }

    public String toString() {
        if (this._cachedToString == null) {
            this._cachedToString = JWNL.resolveMessage("DATA_TOSTRING_002", new Object[]{this.getLemma(), this.getPOS()});
        }
        return this._cachedToString;
    }

    public POS getPOS() {
        return this._pos;
    }

    public String getLemma() {
        return this._lemma;
    }

    public long[] getSynsetOffsets() {
        return this._synsetOffsets;
    }

    public Object getKey() {
        return this.getLemma();
    }

    public int getSenseCount() {
        return this._synsetOffsets.length;
    }

    public Synset[] getSenses() throws JWNLException {
        if (!this._synsetsLoaded) {
            int n = 0;
            while (n < this.getSynsetOffsets().length) {
                this.loadSynset(n);
                ++n;
            }
            this._synsetsLoaded = true;
        }
        return this._synsets;
    }

    public Synset getSense(int n) throws JWNLException {
        this.loadSynset(n - 1);
        return this._synsets[n - 1];
    }

    private void loadSynset(int n) throws JWNLException {
        if (this._synsets[n] == null) {
            this._synsets[n] = Dictionary.getInstance().getSynsetAt(this._pos, this._synsetOffsets[n]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._pos = POS.getPOSForKey(this._pos.getKey());
        this._synsets = new Synset[this._synsetOffsets.length];
    }
}

