/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.fst;

import edu.umass.cs.mallet.base.fst.Transducer;
import edu.umass.cs.mallet.base.types.InstanceList;
import java.io.PrintStream;

public abstract class TransducerEvaluator {
    protected int numIterationsToWait = 0;
    protected int numIterationsToSkip = 0;
    protected boolean alwaysEvaluateWhenFinished = true;
    protected boolean printModelAtEnd = false;
    protected boolean checkpointTransducer = false;
    protected String checkpointFilePrefix = null;
    protected int checkpointIterationsToSkip = 9;
    protected boolean viterbiOutput = true;
    protected String viterbiOutputFilePrefix = null;
    protected int viterbiOutputIterationsToWait = 10;
    protected int viterbiOutputIterationsToSkip = 10;
    protected String viterbiOutputEncoding = "UTF-8";

    public int getNumIterationsToWait() {
        return this.numIterationsToWait;
    }

    public void setNumIterationsToWait(int numIterationsToWait) {
        this.numIterationsToWait = numIterationsToWait;
    }

    public int getNumIterationsToSkip() {
        return this.numIterationsToSkip;
    }

    public void setNumIterationsToSkip(int numIterationsToSkip) {
        this.numIterationsToSkip = numIterationsToSkip;
    }

    public boolean isAlwaysEvaluateWhenFinished() {
        return this.alwaysEvaluateWhenFinished;
    }

    public void setAlwaysEvaluateWhenFinished(boolean alwaysEvaluateWhenFinished) {
        this.alwaysEvaluateWhenFinished = alwaysEvaluateWhenFinished;
    }

    public boolean isPrintModelAtEnd() {
        return this.printModelAtEnd;
    }

    public void setPrintModelAtEnd(boolean printModelAtEnd) {
        this.printModelAtEnd = printModelAtEnd;
    }

    public void setViterbiOutput(boolean vo) {
        this.viterbiOutput = vo;
    }

    public boolean getViterbiOutput() {
        return this.viterbiOutput;
    }

    public void setViterbiOutputFilePrefix(String p) {
        this.viterbiOutputFilePrefix = p;
    }

    public String getViterbiOutputFilePrefix() {
        return this.viterbiOutputFilePrefix;
    }

    public void setViterbiOutputIterationsToWait(int i) {
        this.viterbiOutputIterationsToWait = i;
    }

    public int getViterbiOutputIterationsToWait() {
        return this.viterbiOutputIterationsToWait;
    }

    public void setViterbiOutputIterationsToSkip(int i) {
        this.viterbiOutputIterationsToSkip = i;
    }

    public int getViterbiOutputIterationsToSkip() {
        return this.viterbiOutputIterationsToSkip;
    }

    public void setViterbiOutputEncoding(String o) {
        this.viterbiOutputEncoding = o;
    }

    public String getViterbiOutputEncoding() {
        return this.viterbiOutputEncoding;
    }

    public void setCheckpointTransducer(boolean c) {
        this.checkpointTransducer = c;
    }

    public boolean getCheckpointTransducer() {
        return this.checkpointTransducer;
    }

    public void setCheckpointFilePrefix(String p) {
        this.checkpointFilePrefix = p;
    }

    public String getCheckpointFilePrefix() {
        return this.checkpointFilePrefix;
    }

    public void setCheckpointIterationsToSkip(int i) {
        this.checkpointIterationsToSkip = i;
    }

    public int getCheckpointIterationsToSkip() {
        return this.checkpointIterationsToSkip;
    }

    protected boolean shouldDoEvaluate(int iteration, boolean finishedTraining) {
        if (!(iteration >= this.numIterationsToWait || this.alwaysEvaluateWhenFinished && finishedTraining)) {
            return false;
        }
        return this.numIterationsToSkip <= 0 || iteration % this.numIterationsToSkip == 0 || this.alwaysEvaluateWhenFinished && finishedTraining;
    }

    public boolean evaluate(Transducer crf, boolean finishedTraining, int iteration, boolean converged, double cost, InstanceList training, InstanceList validation, InstanceList testing) {
        if (this.shouldDoEvaluate(iteration, finishedTraining)) {
            InstanceList[] lists = new InstanceList[]{training, validation, testing};
            String[] listnames = new String[]{"Training", "Validation", "Testing"};
            int k = 0;
            while (k < lists.length) {
                if (lists[k] != null) {
                    this.test(crf, lists[k], listnames[k], null);
                }
                ++k;
            }
        }
        return true;
    }

    public abstract void test(Transducer var1, InstanceList var2, String var3, PrintStream var4);
}

