/*
 * Decompiled with CFR 0.152.
 */
package Jet.Lex;

import Jet.Lex.Lexicon;
import Jet.Lex.Tokenizer;
import Jet.Lisp.FeatureSet;
import Jet.Pat.PatternSyntaxError;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StreamTokenizer;
import java.util.Vector;

public class EnglishLex {
    public static void readLexicon(String string) throws IOException {
        System.err.println("Reading lexicon " + string);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        LineNumberReader lineNumberReader = new LineNumberReader(bufferedReader);
        StreamTokenizer streamTokenizer = new StreamTokenizer(lineNumberReader);
        int n = 0;
        while (streamTokenizer.nextToken() != -1) {
            try {
                EnglishLex.readLexiconDefinition(streamTokenizer);
                ++n;
            }
            catch (PatternSyntaxError patternSyntaxError) {
                int n2 = lineNumberReader.getLineNumber();
                System.err.println("*** syntax error in lexicon, line " + n2);
                System.err.println(patternSyntaxError.toString());
                if (streamTokenizer.ttype == -3) {
                    System.err.println("Current token = " + streamTokenizer.sval);
                } else {
                    System.err.println("Current token = " + (char)streamTokenizer.ttype);
                }
                while (streamTokenizer.nextToken() != 59) {
                    if (streamTokenizer.ttype != -1) continue;
                    return;
                }
            }
        }
        System.err.println(n + " lexical entries read");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void readLexiconDefinition(StreamTokenizer streamTokenizer) throws IOException, PatternSyntaxError {
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        if (streamTokenizer.ttype == -3) {
            do {
                vector.addElement(streamTokenizer.sval);
            } while (streamTokenizer.nextToken() == -3);
            stringArray = vector.toArray(new String[0]);
        } else {
            if (streamTokenizer.ttype != 34) throw new PatternSyntaxError();
            stringArray = Tokenizer.tokenize(streamTokenizer.sval);
            streamTokenizer.nextToken();
        }
        if (streamTokenizer.ttype == 59) {
            return;
        }
        if (streamTokenizer.ttype != 44) {
            throw new PatternSyntaxError(", expected");
        }
        if (streamTokenizer.nextToken() == -3) {
            String string = streamTokenizer.sval;
            if (streamTokenizer.nextToken() == 44) {
                FeatureSet featureSet = new FeatureSet(streamTokenizer, false, ';');
                EnglishLex.defineEnglishEntry(stringArray, string, featureSet);
                return;
            }
            if (streamTokenizer.ttype == 59) {
                EnglishLex.defineEnglishEntry(stringArray, string, new FeatureSet());
                return;
            }
            System.err.println("In defn of " + stringArray[0].toString());
            throw new PatternSyntaxError(", or ; expected");
        }
        if (streamTokenizer.ttype == 44) {
            FeatureSet featureSet = new FeatureSet(streamTokenizer, false, ';');
            Lexicon.addEntry(stringArray, featureSet);
            return;
        }
        if (streamTokenizer.ttype != 59) throw new PatternSyntaxError("entry type expected");
    }

    private static void defineEnglishEntry(String[] stringArray, String string, FeatureSet featureSet) throws PatternSyntaxError {
        if (string.equals("noun")) {
            EnglishLex.defineEnglishNoun(stringArray, featureSet);
        } else if (string.equals("verb")) {
            EnglishLex.defineEnglishVerb(stringArray, featureSet);
        } else if (string.equals("adj")) {
            EnglishLex.defineEnglishAdjective(stringArray, featureSet);
        } else if (string.equals("adv")) {
            EnglishLex.defineEnglishAdverb(stringArray, featureSet);
        } else if (string.equals("name")) {
            EnglishLex.defineEnglishName(stringArray, featureSet);
        } else {
            throw new PatternSyntaxError("unknown entry type");
        }
    }

    private static void defineEnglishNoun(String[] stringArray, FeatureSet featureSet) {
        String[] stringArray2;
        String string = EnglishLex.makeString(featureSet.get("plural"));
        FeatureSet featureSet2 = (FeatureSet)featureSet.get("attributes");
        String string2 = EnglishLex.makeString(featureSet.get("xn"));
        String string3 = string2 == null ? EnglishLex.fuseWithUnderscores(stringArray) : string2;
        FeatureSet featureSet3 = new FeatureSet("cat", "n", "number", "singular", "pa", new FeatureSet("head", string3, "number", "singular"));
        featureSet3.putAll(featureSet2);
        Lexicon.addEntry(stringArray, featureSet3);
        if (string == null) {
            stringArray2 = EnglishLex.nounPlural(stringArray);
        } else {
            if (string.equals("none")) {
                return;
            }
            stringArray2 = Tokenizer.tokenize(string);
        }
        FeatureSet featureSet4 = new FeatureSet("cat", "n", "number", "plural", "pa", new FeatureSet("head", string3, "number", "plural"));
        featureSet4.putAll(featureSet2);
        Lexicon.addEntry(stringArray2, featureSet4);
    }

    private static String makeString(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    private static void defineEnglishVerb(String[] stringArray, FeatureSet featureSet) {
        String string = EnglishLex.makeString(featureSet.get("thirdSing"));
        String string2 = EnglishLex.makeString(featureSet.get("plural"));
        String string3 = EnglishLex.makeString(featureSet.get("past"));
        String string4 = EnglishLex.makeString(featureSet.get("pastPart"));
        String string5 = EnglishLex.makeString(featureSet.get("presPart"));
        FeatureSet featureSet2 = (FeatureSet)featureSet.get("attributes");
        String string6 = (String)featureSet.get("xn");
        String string7 = string6 == null ? EnglishLex.fuseWithUnderscores(stringArray) : string6;
        FeatureSet featureSet3 = new FeatureSet("cat", "v", "pa", new FeatureSet("head", string7));
        featureSet3.putAll(featureSet2);
        Lexicon.addEntry(stringArray, featureSet3);
        FeatureSet featureSet4 = new FeatureSet("cat", "tv", "number", "singular", "pa", new FeatureSet("head", string7, "tense", "present"));
        featureSet4.putAll(featureSet2);
        if (string == null) {
            Lexicon.addEntry(EnglishLex.nounPlural(stringArray), featureSet4);
        } else {
            Lexicon.addEntry(Tokenizer.tokenize(string), featureSet4);
        }
        FeatureSet featureSet5 = new FeatureSet("cat", "tv", "number", "plural", "pa", new FeatureSet("head", string7, "tense", "present"));
        featureSet5.putAll(featureSet2);
        if (string2 == null) {
            Lexicon.addEntry(stringArray, featureSet5);
        } else {
            Lexicon.addEntry(Tokenizer.tokenize(string2), featureSet5);
        }
        FeatureSet featureSet6 = new FeatureSet("cat", "tv", "pa", new FeatureSet("head", string7, "tense", "past"));
        featureSet6.putAll(featureSet2);
        if (string3 == null) {
            Lexicon.addEntry(EnglishLex.verbPast(stringArray), featureSet6);
        } else {
            Lexicon.addEntry(Tokenizer.tokenize(string3), featureSet6);
        }
        FeatureSet featureSet7 = new FeatureSet("cat", "ving", "pa", new FeatureSet("head", string7));
        featureSet7.putAll(featureSet2);
        if (string5 == null) {
            Lexicon.addEntry(EnglishLex.verbPresPart(stringArray), featureSet7);
        } else {
            Lexicon.addEntry(Tokenizer.tokenize(string5), featureSet7);
        }
        FeatureSet featureSet8 = new FeatureSet("cat", "ven", "pa", new FeatureSet("head", string7));
        featureSet8.putAll(featureSet2);
        if (string4 == null) {
            Lexicon.addEntry(EnglishLex.verbPast(stringArray), featureSet8);
        } else {
            Lexicon.addEntry(Tokenizer.tokenize(string4), featureSet8);
        }
    }

    private static void defineEnglishAdjective(String[] stringArray, FeatureSet featureSet) {
        FeatureSet featureSet2 = (FeatureSet)featureSet.get("attributes");
        String string = EnglishLex.fuseWithUnderscores(stringArray);
        FeatureSet featureSet3 = new FeatureSet("cat", "adj", "pa", new FeatureSet("head", string));
        featureSet3.putAll(featureSet2);
        Lexicon.addEntry(stringArray, featureSet3);
    }

    private static void defineEnglishAdverb(String[] stringArray, FeatureSet featureSet) {
        FeatureSet featureSet2 = (FeatureSet)featureSet.get("attributes");
        String string = EnglishLex.fuseWithUnderscores(stringArray);
        FeatureSet featureSet3 = new FeatureSet("cat", "adv", "pa", new FeatureSet("head", string));
        featureSet3.putAll(featureSet2);
        Lexicon.addEntry(stringArray, featureSet3);
    }

    private static void defineEnglishName(String[] stringArray, FeatureSet featureSet) {
        String string = (String)featureSet.get("class");
        FeatureSet featureSet2 = new FeatureSet("cat", "name");
        if (string != null) {
            featureSet2.put("class", string);
        }
        Lexicon.addEntry(stringArray, featureSet2);
    }

    private static String fuseWithUnderscores(String[] stringArray) {
        String string = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string = string + "_" + stringArray[i];
        }
        return string;
    }

    public static String[] nounPlural(String[] stringArray) {
        int n;
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringArray2[i] = stringArray[i];
        }
        String string = stringArray[stringArray.length - 1];
        int n2 = string.length();
        char c = string.charAt(n2 - 1);
        int n3 = n = string.length() > 1 ? (int)string.charAt(n2 - 2) : 32;
        String string2 = c == 's' || c == 'z' || c == 'x' || (n == 99 || n == 115) && c == 'h' ? string + "es" : (c == 'y' ? (n == 97 || n == 101 || n == 105 || n == 111 || n == 121 ? string + "s" : string.substring(0, n2 - 1) + "ies") : string + "s");
        stringArray2[stringArray.length - 1] = string2;
        return stringArray2;
    }

    private static String[] verbPast(String[] stringArray) {
        int n;
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringArray2[i] = stringArray[i];
        }
        String string = stringArray[stringArray.length - 1];
        int n2 = string.length();
        char c = string.charAt(n2 - 1);
        int n3 = n = string.length() > 1 ? (int)string.charAt(n2 - 2) : 32;
        String string2 = c == 'e' ? string + "d" : (c == 'y' ? (n == 97 || n == 101 || n == 105 || n == 111 || n == 121 ? string + "ed" : string.substring(0, n2 - 1) + "ied") : string + "ed");
        stringArray2[stringArray.length - 1] = string2;
        return stringArray2;
    }

    private static String[] verbPresPart(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringArray2[i] = stringArray[i];
        }
        String string = stringArray[stringArray.length - 1];
        int n = string.length();
        char c = string.charAt(n - 1);
        String string2 = c == 'e' ? string.substring(0, n - 1) + "ing" : string + "ing";
        stringArray2[stringArray.length - 1] = string2;
        return stringArray2;
    }
}

