/*
 * Decompiled with CFR 0.152.
 */
package Jet;

import Jet.Console;
import Jet.Control;
import Jet.JetTest;
import Jet.Lisp.FeatureSet;
import Jet.Pat.Pat;
import Jet.Refres.Resolve;
import Jet.Scorer.SGMLProcessor;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Vector;

public class EntityFinder {
    static final int MaxProcessSentences = 100;

    static void writeDocRaw(Document document, PrintStream printStream) throws IOException {
        printStream.println(document.writeSGML(null).toString());
        printStream.flush();
    }

    static void writeDoc1(Document document, PrintStream printStream) throws IOException {
        Object object;
        Object object2;
        Vector<Annotation> vector = document.annotationsOfType("entity");
        if (vector == null) {
            System.err.println("No Entity: " + document);
            return;
        }
        Iterator<Annotation> iterator = vector.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object2 = iterator.next();
            object = (Vector)((Annotation)object2).get("mentions");
            Iterator iterator2 = ((Vector)object).iterator();
            String string = (String)((Annotation)object2).get("nameType");
            while (iterator2.hasNext()) {
                Annotation annotation = (Annotation)iterator2.next();
                Annotation annotation2 = new Annotation("refobj", annotation.span(), new FeatureSet());
                annotation2.put("objid", Integer.toString(n));
                if (string != null) {
                    annotation2.put("netype", string);
                }
                document.addAnnotation(annotation2);
            }
            ++n;
        }
        object2 = document.getAnnotationTypes();
        for (n = 0; n < ((Object)object2).length; ++n) {
            object = object2[n];
            if (((String)object).equals("tagger") || ((String)object).equals("refobj") || ((String)object).equals("ENAMEX")) continue;
            document.removeAnnotationsOfType((String)object);
        }
        EntityFinder.writeDocRaw(document, printStream);
    }

    static void processDoc1(Document document, int n) throws IOException {
        String string = JetTest.config.getProperty("processDocument");
        if (JetTest.nameTagger != null) {
            JetTest.nameTagger.newDocument();
        }
        Span span = new Span(0, document.length());
        Control.applyScript(document, span, string);
    }

    static void processFile(String string, PrintStream printStream) throws IOException {
        System.err.println("Processing: " + string);
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, JetTest.encoding);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            String[] stringArray;
            String string2;
            if ((string2 = bufferedReader.readLine()) == null || string2.equals("")) {
                if (0 < stringBuffer.length()) {
                    SGMLProcessor.allTags = true;
                    stringArray = SGMLProcessor.sgmlToDoc(stringBuffer.toString(), (String[])null);
                    stringArray.setSGMLwrapMargin(0);
                    System.err.println("Doc-" + n + ": sents=" + n2 + ", processed=" + n3);
                    EntityFinder.processDoc1((Document)stringArray, n);
                    EntityFinder.writeDoc1((Document)stringArray, printStream);
                    printStream.flush();
                    stringBuffer = new StringBuffer();
                    ++n;
                    n2 = 0;
                    n3 = 0;
                }
                if (string2 != null) continue;
                break;
            }
            if (string2.startsWith("#")) {
                stringBuffer.append(string2 + "\n");
                continue;
            }
            ++n2;
            if (n3 >= 100) continue;
            stringBuffer.append("<sentence>");
            stringArray = string2.split(" ");
            for (int i = 0; i < stringArray.length; ++i) {
                if (0 == stringArray[i].length()) continue;
                stringBuffer.append("<token>" + stringArray[i] + " </token>");
            }
            stringBuffer.append("</sentence>\n");
            ++n3;
        }
        bufferedReader.close();
        inputStreamReader.close();
        fileInputStream.close();
    }

    public static void main(String[] stringArray) throws IOException, ClassNotFoundException {
        if (stringArray.length < 2) {
            System.err.println("usage: java EntityFinder propfile datapath files ...");
            System.exit(2);
        }
        JetTest.initializeFromConfig(stringArray[0], stringArray[1]);
        Pat.trace = false;
        Resolve.trace = false;
        String string = JetTest.config.getProperty("processDocument");
        if (string == null || string.length() == 0) {
            Console.println("*** System error: no processDocument script.");
            return;
        }
        for (int i = 2; i < stringArray.length; ++i) {
            EntityFinder.processFile(stringArray[i], System.out);
        }
    }
}

