/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import org.pnuts.lang.NodeUtil;
import pnuts.compiler.Compiler;
import pnuts.lang.Binding;
import pnuts.lang.Context;
import pnuts.lang.Function;
import pnuts.lang.Package;
import pnuts.lang.ParseException;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsFunction;
import pnuts.lang.PnutsParser;
import pnuts.lang.Runtime;
import pnuts.lang.SimpleNode;

class DefaultFunctionSerializer
implements Runtime.FunctionSerializer {
    DefaultFunctionSerializer() {
    }

    public void serialize(PnutsFunction pnutsFunction, ObjectOutputStream s) throws IOException {
        Function[] functions = pnutsFunction.functions;
        s.writeUTF(pnutsFunction.pkg.getName());
        int n = functions.length;
        s.writeInt(n);
        for (int i = 0; i < n; ++i) {
            Function f = functions[i];
            SimpleNode node = null;
            if (f != null) {
                node = f.node;
                if (node != null) {
                    s.writeObject(f);
                    continue;
                }
                node = f.getNode();
                if (node != null) {
                    s.writeObject(node);
                } else {
                    s.writeObject(f.unparse(null));
                }
                f.writeAttributes(s);
                continue;
            }
            s.writeObject(null);
        }
    }

    public void deserialize(PnutsFunction pnutsFunction, ObjectInputStream s) throws IOException, ClassNotFoundException {
        Context c2;
        String pkgName = s.readUTF();
        Context threadContext = Runtime.getThreadContext();
        int n = s.readInt();
        Function[] functions = new Function[n];
        pnutsFunction.functions = functions;
        boolean[] compile = new boolean[n];
        boolean compileString = false;
        boolean compileNode = false;
        StringBuffer sbuf = new StringBuffer();
        ArrayList<SimpleNode> nodes = new ArrayList<SimpleNode>();
        Package pkg = null;
        for (int i = 0; i < n; ++i) {
            Object f = s.readObject();
            if (f instanceof Function) {
                functions[i] = (Function)f;
                continue;
            }
            if (f instanceof SimpleNode) {
                Function func;
                SimpleNode ss = new SimpleNode(1);
                SimpleNode node = (SimpleNode)f;
                functions[i] = func = new Function();
                compile[i] = true;
                compileNode = true;
                func.node = node.jjtGetChild(1);
                func.readAttributes(s);
                func.setPackage(Package.find(func.pkgName, threadContext));
                NodeUtil.setPackage(func.pkgName, ss);
                String[] imports = func.importEnv.list();
                for (int j = 0; j < imports.length; ++j) {
                    NodeUtil.addImportNode(imports[j], ss);
                }
                NodeUtil.addFunction(node, ss);
                nodes.add(ss);
                continue;
            }
            if (!(f instanceof String)) continue;
            String unparsed = (String)f;
            try {
                Function func = new Function();
                func.readAttributes(s);
                func.setPackage(Package.find(func.pkgName, threadContext));
                sbuf.append("package(\"");
                sbuf.append(func.pkgName);
                sbuf.append("\")\n");
                String[] imports = func.importEnv.list();
                for (int j = 0; j < imports.length; ++j) {
                    sbuf.append("import " + imports[j] + "\n");
                }
                sbuf.append((String)f);
                sbuf.append("\n");
                PnutsParser parser = Pnuts.getParser(new StringReader(unparsed));
                SimpleNode node = parser.FunctionStatement(null);
                func.node = node.jjtGetChild(1);
                func.function = pnutsFunction;
                functions[i] = func;
                compile[i] = true;
                compileString = true;
                continue;
            }
            catch (ParseException pe) {
                pe.printStackTrace();
            }
        }
        pnutsFunction.pkg = Package.find(pkgName, threadContext);
        Compiler compiler = null;
        if (compileString || compileNode) {
            compiler = new Compiler();
            pkg = new Package(null, null);
        }
        if (compileString) {
            c2 = threadContext != null ? (Context)threadContext.clone() : new Context();
            c2.setCurrentPackage(pkg);
            Pnuts compiled = compiler.compile(sbuf.toString(), c2);
            PnutsFunction pf = (PnutsFunction)compiled.run(c2);
            pf.pkg = Package.find(pkgName, threadContext);
            for (int i = 0; i < functions.length; ++i) {
                Function f = functions[i];
                if (f == null || !compile[i]) continue;
                Function f2 = pf.functions[i];
                f2.moduleList = f.moduleList;
                f2.config = f.config;
                Package p = Package.getPackage(f.pkg.getName(), c2);
                Enumeration e = f.pkg.bindings();
                while (e.hasMoreElements()) {
                    Binding binding = (Binding)e.nextElement();
                    p.set(binding.getName(), binding.get());
                }
                f2.pkg = p;
                f2.pkgName = f.pkgName;
                f2.file = null;
                functions[i] = f2;
            }
        }
        if (compileNode) {
            Context context = c2 = threadContext != null ? (Context)threadContext.clone() : new Context();
            if (pkg != null) {
                c2.setCurrentPackage(pkg);
            }
            int sz = nodes.size();
            for (int j = 0; j < sz; ++j) {
                SimpleNode ss = (SimpleNode)nodes.get(j);
                Pnuts compiled = compiler.compile((Pnuts)new P(ss), c2);
                PnutsFunction pf = (PnutsFunction)compiled.run(c2);
                for (int i = 0; i < pf.functions.length; ++i) {
                    Function f2;
                    Function f = functions[i];
                    if (f == null || !compile[i] || (f2 = pf.functions[i]) == null) continue;
                    f2.moduleList = f.moduleList;
                    f2.config = f.config;
                    f2.pkg = f.pkg;
                    f2.pkgName = f.pkgName;
                    f2.file = f.file;
                    functions[i] = f2;
                }
            }
        }
    }

    static class P
    extends Pnuts {
        public P(SimpleNode ss) {
            this.startNodes = ss;
        }
    }
}

