/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.classify;

import edu.umass.cs.mallet.base.classify.Classifier;
import edu.umass.cs.mallet.base.types.Instance;
import edu.umass.cs.mallet.base.types.LabelVector;
import edu.umass.cs.mallet.base.types.Labeling;

public class Classification {
    Instance instance;
    Classifier classifier;
    Labeling labeling;

    public Classification(Instance instance, Classifier classifier, Labeling labeling) {
        this.instance = instance;
        this.classifier = classifier;
        this.labeling = labeling;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public Classifier getClassifier() {
        return this.classifier;
    }

    public Labeling getLabeling() {
        return this.labeling;
    }

    public LabelVector getLabelVector() {
        return this.labeling.toLabelVector();
    }

    public boolean bestLabelIsCorrect() {
        Labeling correctLabeling = this.instance.getLabeling();
        if (correctLabeling == null) {
            throw new IllegalStateException("Instance has no label.");
        }
        return this.labeling.getBestLabel().equals(correctLabeling.getBestLabel());
    }

    public double valueOfCorrectLabel() {
        Labeling correctLabeling = this.instance.getLabeling();
        int correctLabelIndex = correctLabeling.getBestIndex();
        return this.labeling.value(correctLabelIndex);
    }

    public void print() {
        System.out.print(String.valueOf(this.classifier.getClass().getName()) + "(.");
        System.out.print(") = [");
        int i = 0;
        while (i < this.labeling.numLocations()) {
            System.out.print(String.valueOf(this.labeling.labelAtLocation(i).toString()) + "=" + this.labeling.valueAtLocation(i) + " ");
            ++i;
        }
        System.out.println("]");
    }
}

