/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.pnuts.util.Cache;

public class LRUCache
implements Cache {
    private Cell[] cells;
    private int size;
    private Cell head;
    private Cell tail;
    private int count = 0;

    protected LRUCache() {
    }

    public LRUCache(int size) {
        this.cells = new Cell[size];
        this.size = size;
    }

    void update(Cell b) {
        if (b != this.tail) {
            if (b.prev != null) {
                b.prev.next = b.next;
            }
            if (b.next != null) {
                b.next.prev = b.prev;
            }
            this.tail.next = b;
            b.prev = this.tail;
            this.tail = b;
        }
        if (b == this.head) {
            this.head = b.next;
        }
        b.next = null;
    }

    private Cell findCell(Object key) {
        int index = (key.hashCode() & Integer.MAX_VALUE) % this.size;
        Cell b = this.cells[index];
        while (b != null) {
            if (b.key.equals(key)) {
                this.update(b);
                return b;
            }
            b = b.chain;
        }
        return null;
    }

    public Object get(Object key) {
        Cell cell = this.findCell(key);
        if (cell != null) {
            return cell.value;
        }
        return null;
    }

    public Object put(Object key, Object value) {
        int index = (key.hashCode() & Integer.MAX_VALUE) % this.size;
        Cell b = this.cells[index];
        Cell n = null;
        Object old = null;
        while (b != null) {
            if (b.key.equals(key)) {
                old = b.value;
                b.value = value;
                this.update(b);
                return old;
            }
            b = b.chain;
        }
        if (this.head != null) {
            if (this.count >= this.size) {
                Cell second = this.head.next;
                n = this.head;
                this.expired(n.value);
                n.prev = this.tail;
                this.tail.next = n;
                n.next = null;
                n.key = key;
                n.value = value;
                if (n.index == index) {
                    if (n != this.cells[index]) {
                        Cell x = this.cells[index];
                        while (true) {
                            if (x.chain == null) {
                                throw new RuntimeException("[BUG] Reused cell must be found in the chain of index=" + index);
                            }
                            if (x.chain == n) break;
                            x = x.chain;
                        }
                        x.chain = n.chain;
                        n.chain = this.cells[index];
                        this.cells[index] = n;
                    }
                } else {
                    Cell t = this.cells[n.index];
                    if (t == n) {
                        this.cells[n.index] = n.chain;
                    } else {
                        while (t != null && t.chain != null) {
                            if (t.chain == n) {
                                t.chain = n.chain;
                                break;
                            }
                            t = t.chain;
                        }
                    }
                    n.chain = this.cells[index];
                    this.cells[index] = n;
                }
                n.index = index;
                this.head = second;
                if (this.head == null) {
                    this.head = n;
                }
                this.tail = n;
            } else {
                ++this.count;
                this.cells[index] = n = new Cell(index, this.tail, this.cells[index], key, value);
                this.tail.next = n;
                this.tail = n;
            }
        } else {
            ++this.count;
            n.prev = n = new Cell(index, null, this.cells[index], key, value);
            n.next = n;
            this.cells[index] = n;
            this.head = n;
            this.tail = n;
        }
        return old;
    }

    public void expired(Object old) {
    }

    public void reset() {
        this.tail = null;
        this.head = null;
        this.cells = new Cell[this.size];
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public Set keySet() {
        HashSet keys = new HashSet();
        Itr it = new Itr(0);
        while (it.hasNext()) {
            keys.add(it.next());
        }
        return keys;
    }

    public Set entrySet() {
        HashSet entries = new HashSet();
        Itr it = new Itr(2);
        while (it.hasNext()) {
            entries.add(it.next());
        }
        return entries;
    }

    public Collection values() {
        ArrayList v = new ArrayList();
        Itr it = new Itr(1);
        while (it.hasNext()) {
            v.add(it.next());
        }
        return v;
    }

    class Itr
    implements Iterator {
        Cell ref;
        int kind;

        Itr(int kind) {
            this.ref = LRUCache.this.head;
            this.kind = kind;
        }

        public boolean hasNext() {
            return this.ref != null;
        }

        public Object next() {
            switch (this.kind) {
                case 0: {
                    Object key = this.ref.key;
                    this.ref = this.ref.next;
                    return key;
                }
                case 1: {
                    Object value = this.ref.value;
                    this.ref = this.ref.next;
                    return value;
                }
                case 2: {
                    Cell entry = this.ref;
                    this.ref = this.ref.next;
                    return entry;
                }
            }
            throw new RuntimeException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class Cell
    implements Map.Entry {
        Cell next;
        Cell prev;
        Cell chain;
        Object key;
        Object value;
        int index;

        Cell(int index, Cell prev, Cell chain, Object key, Object value) {
            this.index = index;
            this.prev = prev;
            this.chain = chain;
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object old = this.value;
            this.value = value;
            return old;
        }

        public int hashCode() {
            return this.key.hashCode() + this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Cell) {
                Cell c = (Cell)obj;
                return (this.key == null && c.key == null || this.key.equals(c.key)) && (this.value == null && c.value == null || this.value.equals(c.value));
            }
            return false;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

