/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.data.DictionaryElement;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Pointer;
import net.didion.jwnl.data.PointerTarget;
import net.didion.jwnl.data.VerbFrame;
import net.didion.jwnl.data.Word;

public class Synset
extends PointerTarget
implements DictionaryElement {
    static final long serialVersionUID = 4038955719653496529L;
    private POS _pos;
    private Pointer[] _pointers;
    private long _offset;
    private Word[] _words;
    private String _gloss;
    private long _verbFrames;
    private transient String _cachedToString = null;

    public Synset(POS pOS, long l, Word[] wordArray, Pointer[] pointerArray, String string, long l2) {
        this(pOS, l, wordArray, pointerArray, string, l2, false);
    }

    public Synset(POS pOS, long l, Word[] wordArray, Pointer[] pointerArray, String string, long l2, boolean bl) {
        this._pos = pOS;
        this._pointers = pointerArray;
        this._offset = l;
        this._words = wordArray;
        this._gloss = string;
        this._verbFrames = l2;
    }

    public boolean equals(Object object) {
        return object instanceof Synset && ((Synset)object).getPOS().equals(this.getPOS()) && ((Synset)object).getOffset() == this.getOffset();
    }

    public int hashCode() {
        return this.getPOS().hashCode() ^ (int)this.getOffset();
    }

    public String toString() {
        if (this._cachedToString == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.getWordsSize()) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.getWord(n).getLemma());
                ++n;
            }
            if (this.getGloss() != null) {
                stringBuffer.append(" -- (" + this.getGloss() + ")");
            }
            this._cachedToString = JWNL.resolveMessage("DATA_TOSTRING_009", new Object[]{new Long(this.getOffset()), this.getPOS(), stringBuffer.toString()});
        }
        return this._cachedToString;
    }

    public POS getPOS() {
        return this._pos;
    }

    public Pointer[] getPointers() {
        return this._pointers;
    }

    public String getGloss() {
        return this._gloss;
    }

    public Word[] getWords() {
        return this._words;
    }

    public int getWordsSize() {
        return this.getWords().length;
    }

    public Word getWord(int n) {
        return this._words[n];
    }

    public long getOffset() {
        return this._offset;
    }

    public Object getKey() {
        return new Long(this.getOffset());
    }

    public String[] getVerbFrames() {
        return VerbFrame.getFrames(this._verbFrames);
    }

    public boolean containsWord(String string) {
        int n = 0;
        while (n < this.getWordsSize()) {
            if (this.getWord(n).getLemma().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._pos = POS.getPOSForKey(this._pos.getKey());
    }
}

