/*
 * Decompiled with CFR 0.152.
 */
package tratz.semantics.psd.training;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import tratz.runpipe.TextDocument;
import tratz.runpipe.TextDocumentReader;
import tratz.runpipe.annotations.Sentence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneSentencePerLineDocReader
implements TextDocumentReader {
    @Override
    public void initialize(Map<String, String> params) {
    }

    @Override
    public void hydrateDocument(InputStream istream, TextDocument doc) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(istream));
        String l = null;
        ArrayList<String> sentences = new ArrayList<String>();
        while ((l = reader.readLine()) != null) {
            sentences.add(l);
        }
        StringBuffer docText = new StringBuffer();
        int sentenceNum = 1;
        int start = 0;
        for (String sentence : sentences) {
            sentence = sentence.replaceAll("\"([^\"]+)\"", "``$1''");
            int length = sentence.length();
            Sentence newSentence = new Sentence(doc, start, start + length);
            newSentence.setSentenceNum(sentenceNum++);
            doc.addAnnotation(newSentence);
            docText.append(sentence);
            start += length;
        }
        doc.setText(docText.toString());
        reader.close();
    }
}

