/*
 * Decompiled with CFR 0.152.
 */
package Jet.Refres;

import Jet.Lisp.FeatureSet;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;

public class CorefFilter {
    private static HashMap idToMention;
    private static HashMap mentionToEntity;

    public static void buildEntitiesFromMentions(Document document) {
        Vector<Object> vector;
        HashMap<Object, Vector<Object>> hashMap = new HashMap<Object, Vector<Object>>();
        Vector<Annotation> vector2 = document.annotationsOfType("mention");
        for (int i = 0; i < vector2.size(); ++i) {
            Annotation annotation = vector2.get(i);
            Object object = annotation.get("entity");
            if (object == null) {
                System.err.println("CorefEval.buildEntities:  mention annotation without entity id");
                continue;
            }
            vector = (Vector<Object>)hashMap.get(object);
            if (vector == null) {
                vector = new Vector<Object>();
            }
            vector.add(annotation);
            hashMap.put(object, vector);
        }
        Set set = hashMap.keySet();
        for (Object object : set) {
            vector = (Vector)hashMap.get(object);
            Annotation annotation = (Annotation)vector.get(0);
            document.annotate("entity", annotation.span(), new FeatureSet("mentions", vector));
        }
    }

    public static void buildEntitiesFromLinkedMentions(Document document) {
        Annotation annotation;
        int n;
        Vector<Annotation> vector = document.annotationsOfType("coref");
        if (vector == null) {
            return;
        }
        idToMention = new HashMap();
        for (n = 0; n < vector.size(); ++n) {
            annotation = vector.get(n);
            Object object = annotation.get("id");
            if (object == null) {
                System.err.println("(buildEntitiesFromRefs) coref annotation without id");
                continue;
            }
            idToMention.put(object, annotation);
        }
        mentionToEntity = new HashMap();
        for (n = 0; n < vector.size(); ++n) {
            annotation = vector.get(n);
            CorefFilter.mentionToEntity(annotation, document, 0);
        }
    }

    private static Annotation mentionToEntity(Annotation annotation, Document document, int n) {
        if (n > 100) {
            System.err.println("(mentionToEntity) loop of REF pointers");
            return null;
        }
        Annotation annotation2 = (Annotation)mentionToEntity.get(annotation);
        if (annotation2 != null) {
            return annotation2;
        }
        String string = (String)annotation.get("ref");
        if (string == null) {
            Vector<Annotation> vector = new Vector<Annotation>();
            vector.add(annotation);
            annotation2 = new Annotation("entity", annotation.span(), new FeatureSet("mentions", vector));
            document.addAnnotation(annotation2);
        } else {
            Annotation annotation3 = (Annotation)idToMention.get(string);
            if (annotation3 == null) {
                System.err.println("(mentionToEntity) undefined REF pointer" + string);
            }
            annotation2 = CorefFilter.mentionToEntity(annotation3, document, n + 1);
            Vector vector = (Vector)annotation2.get("mentions");
            vector.add(annotation);
        }
        mentionToEntity.put(annotation, annotation2);
        return annotation2;
    }

    public static void buildMentionsFromEntities(Document document) {
        Vector<Annotation> vector = document.annotationsOfType("entity");
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = vector.get(i);
            Integer n = new Integer(i);
            Vector vector2 = (Vector)annotation.get("mentions");
            for (int j = 0; j < vector2.size(); ++j) {
                Annotation annotation2 = (Annotation)vector2.get(j);
                Annotation annotation3 = Resolve.getHeadC(annotation2);
                if (annotation3.type() != "mention") {
                    annotation3 = new Annotation("mention", annotation3.span(), null);
                    document.addAnnotation(annotation3);
                }
                annotation3.put("entity", n);
            }
        }
    }

    public static void buildLinkedMentionsFromEntities(Document document) {
        int n = 0;
        Vector<Annotation> vector = document.annotationsOfType("entity");
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = vector.get(i);
            Vector vector2 = (Vector)annotation.get("mentions");
            int n2 = 0;
            for (int j = 0; j < vector2.size(); ++j) {
                Annotation annotation2 = (Annotation)vector2.get(j);
                Annotation annotation3 = Resolve.getHeadC(annotation2);
                if (annotation3.type() != "COREF") {
                    annotation3 = new Annotation("COREF", annotation3.span(), null);
                    document.addAnnotation(annotation3);
                }
                annotation3.put("ID", new Integer(++n));
                if (n2 > 0) {
                    annotation3.put("REF", new Integer(n2));
                }
                n2 = n;
            }
        }
    }
}

