/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.AceEventArgument;
import AceJet.AceEventMentionArgument;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternEvaluation {
    int successCount = 0;
    int failureCount = 0;
    HashMap<String, Integer> successWithArg = new HashMap();
    HashMap<String, Integer> failureWithArg = new HashMap();

    public PatternEvaluation() {
    }

    public void recordSuccess(ArrayList arrayList) {
        this.recordSuccess(arrayList, 1);
    }

    public void recordSuccess(ArrayList arrayList, int n) {
        this.successCount += n;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEventMentionArgument aceEventMentionArgument = (AceEventMentionArgument)arrayList.get(i);
            String string = aceEventMentionArgument.role;
            this.increment(this.successWithArg, string, n);
        }
    }

    public void recordFailure(ArrayList arrayList) {
        this.recordFailure(arrayList, 1);
    }

    public void recordFailure(ArrayList arrayList, int n) {
        this.failureCount += n;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEventMentionArgument aceEventMentionArgument = (AceEventMentionArgument)arrayList.get(i);
            String string = aceEventMentionArgument.role;
            this.increment(this.failureWithArg, string, n);
        }
    }

    private void increment(HashMap<String, Integer> hashMap, String string, int n) {
        int n2 = hashMap.get(string) == null ? 0 : hashMap.get(string);
        hashMap.put(string, new Integer(n2 + n));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.successCount + "+/" + this.failureCount + "-(");
        TreeSet<String> treeSet = new TreeSet<String>(this.successWithArg.keySet());
        Set<String> set = this.failureWithArg.keySet();
        treeSet.addAll(set);
        for (String string : treeSet) {
            int n = this.successWithArg.get(string) == null ? 0 : this.successWithArg.get(string);
            int n2 = this.failureWithArg.get(string) == null ? 0 : this.failureWithArg.get(string);
            stringBuffer.append(" " + string + ":" + n + "+/" + n2 + "-");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public int test(ArrayList arrayList, double d) {
        int n = -1;
        if ((double)this.successCount >= (double)this.failureCount * d) {
            n = 50 * this.successCount / (this.successCount + this.failureCount + 10);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            int n2;
            AceEventArgument aceEventArgument = (AceEventArgument)arrayList.get(i);
            String string = aceEventArgument.role;
            int n3 = this.successWithArg.get(string) == null ? 0 : this.successWithArg.get(string);
            int n4 = n2 = this.failureWithArg.get(string) == null ? 0 : this.failureWithArg.get(string);
            if (!((double)n3 >= (double)n2 * d)) continue;
            n = Math.max(n, 50 * n3 / (n3 + n2 + 10));
        }
        return n;
    }

    public void write(PrintWriter printWriter) {
        printWriter.println("noArg | " + this.successCount + " | " + this.failureCount);
        TreeSet<String> treeSet = new TreeSet<String>(this.successWithArg.keySet());
        Set<String> set = this.failureWithArg.keySet();
        treeSet.addAll(set);
        for (String string : treeSet) {
            int n = this.successWithArg.get(string) == null ? 0 : this.successWithArg.get(string);
            int n2 = this.failureWithArg.get(string) == null ? 0 : this.failureWithArg.get(string);
            printWriter.println(string + " | " + n + " | " + n2);
        }
        printWriter.println("$evalEnd");
    }

    public PatternEvaluation(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        while (string != null && !string.equals("$evalEnd")) {
            String[] stringArray = string.split(" \\| ");
            if (stringArray.length != 3) {
                System.err.println("PatternEvaluation:  invalid input " + string);
                return;
            }
            String string2 = stringArray[0];
            try {
                int n = Integer.parseInt(stringArray[1]);
                int n2 = Integer.parseInt(stringArray[2]);
                if (string2.equals("noArg")) {
                    this.successCount = n;
                    this.failureCount = n2;
                } else {
                    this.successWithArg.put(string2, new Integer(n));
                    this.failureWithArg.put(string2, new Integer(n2));
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("PatternEvaluation:  invalid input " + string);
                return;
            }
            string = bufferedReader.readLine();
        }
    }
}

