/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.Ace;
import AceJet.AceDocument;
import AceJet.AceEvent;
import AceJet.AceEventMention;
import AceJet.AceEventMentionArgument;
import AceJet.EventPattern;
import AceJet.EventTagger;
import AceJet.Gazetteer;
import AceJet.NewEventTagger;
import Jet.Control;
import Jet.JetTest;
import Jet.Parser.SyntacticRelationSet;
import Jet.Pat.Pat;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;

public class EventEval {
    static int correctArgs;
    static int missingArgs;
    static int spuriousArgs;
    static int correctEvents;
    static int typeErrorEvents;
    static int missingEvents;
    static int spuriousEvents;
    static NewEventTagger evTagger;
    static final String home = "C:/Documents and Settings/Ralph Grishman/My Documents/";
    static final String ace = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/";
    static final String fileListTest = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/perfect-parses/head6.txt";
    private static AceEvent keyEvent;

    public static void main(String[] stringArray) throws IOException {
        if (EventTagger.useParser) {
            JetTest.initializeFromConfig("props/ace use parses.properties");
        } else {
            JetTest.initializeFromConfig("props/ME ace 05.properties");
        }
        Ace.gazetteer = new Gazetteer();
        Ace.gazetteer.load("data/loc.dict");
        Pat.trace = false;
        Resolve.trace = false;
        AceDocument.ace2005 = true;
        evTagger = new NewEventTagger("eventTemp/");
        evTagger.loadModels();
        EventEval.evalEvents(fileListTest);
    }

    public static void evalEvents(String string) throws IOException {
        String string2;
        EventTagger.useArgumentModel = false;
        EventPattern.useChunkPatterns = true;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        boolean bl = false;
        correctArgs = 0;
        missingArgs = 0;
        spuriousArgs = 0;
        correctEvents = 0;
        typeErrorEvents = 0;
        missingEvents = 0;
        spuriousEvents = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            System.err.println("\nProcessing file " + string2);
            String string3 = ace + (EventTagger.useParser ? "perfect-parses/" : "") + string2;
            String string4 = ace + string2.replaceFirst(".sgm", ".apf.xml");
            String string5 = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/output/" + string2.replaceFirst(".sgm", ".apf");
            String string6 = string2.replaceFirst(".sgm", "");
            ExternalDocument externalDocument = new ExternalDocument("sgml", string3);
            externalDocument.setAllTags(true);
            externalDocument.open();
            Control.processDocument(externalDocument, null, false, 0);
            AceDocument aceDocument = new AceDocument(string3, string4);
            EventEval.evalEvents(externalDocument, aceDocument, string6);
        }
        System.out.println("Events:  " + correctEvents + " correct; " + typeErrorEvents + " type errors; " + missingEvents + " missing; " + spuriousEvents + " spurious");
        System.out.println("Arguments:  " + correctArgs + " correct; " + missingArgs + " missing; " + spuriousArgs + " spurious");
    }

    public static void evalEvents(Document document, AceDocument aceDocument, String string) {
        SyntacticRelationSet syntacticRelationSet = new SyntacticRelationSet();
        if (EventTagger.usePA) {
            syntacticRelationSet.readRelations(EventTagger.glarfDir + string + EventTagger.triplesSuffix);
        } else {
            syntacticRelationSet.addRelations(document);
        }
        ArrayList<AceEvent> arrayList = aceDocument.events;
        Vector<Annotation> vector = document.annotationsOfType("constit");
        HashSet<Span> hashSet = new HashSet<Span>();
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = vector.get(i);
            String string2 = (String)annotation.get("cat");
            if (string2 != "n" && string2 != "v" && string2 != "tv" && string2 != "ven" && string2 != "ving" && string2 != "adj") continue;
            String string3 = EventPattern.normalizedAnchor(annotation, document, syntacticRelationSet);
            Span span = annotation.span();
            if (hashSet.contains(span)) {
                System.err.println("** Skipping duplicate anchor. **");
                continue;
            }
            AceEventMention aceEventMention = EventEval.keyEventMention(span, arrayList);
            AceEvent aceEvent = evTagger.eventAnchoredByConstituent(annotation, document, aceDocument, string, syntacticRelationSet, 0);
            if (aceEventMention != null) {
                ArrayList<AceEventMentionArgument> arrayList2 = aceEventMention.arguments;
                if (aceEvent != null) {
                    hashSet.add(span);
                    if (aceEvent.subtype.equals(EventEval.keyEvent.subtype)) {
                        int n;
                        AceEventMention aceEventMention2 = aceEvent.mentions.get(0);
                        ArrayList<AceEventMentionArgument> arrayList3 = aceEventMention2.arguments;
                        ArrayList<AceEventMentionArgument> arrayList4 = new ArrayList<AceEventMentionArgument>(arrayList3);
                        arrayList4.retainAll(arrayList2);
                        ArrayList<AceEventMentionArgument> arrayList5 = new ArrayList<AceEventMentionArgument>(arrayList3);
                        arrayList5.removeAll(arrayList2);
                        ArrayList<AceEventMentionArgument> arrayList6 = new ArrayList<AceEventMentionArgument>(arrayList2);
                        arrayList6.removeAll(arrayList3);
                        correctArgs += arrayList4.size();
                        spuriousArgs += arrayList5.size();
                        missingArgs += arrayList6.size();
                        System.out.println("For event: " + aceEventMention.text);
                        System.out.println("   type of event:   " + EventEval.keyEvent.subtype);
                        System.out.println("   anchor:          " + string3);
                        for (n = 0; n < arrayList4.size(); ++n) {
                            System.out.println("   correct  argument:  " + arrayList4.get(n));
                        }
                        for (n = 0; n < arrayList5.size(); ++n) {
                            System.out.println("   spurious argument:  " + arrayList5.get(n));
                        }
                        for (n = 0; n < arrayList6.size(); ++n) {
                            System.out.println("   missing  argument:  " + arrayList6.get(n));
                        }
                        ++correctEvents;
                        continue;
                    }
                    ++typeErrorEvents;
                    continue;
                }
                ++missingEvents;
                continue;
            }
            if (aceEvent == null) continue;
            ++spuriousEvents;
            System.err.println("Spurious event of type " + aceEvent.type + ":" + aceEvent.subtype + " for " + string3);
        }
    }

    private static AceEventMention keyEventMention(Span span, ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            keyEvent = (AceEvent)arrayList.get(i);
            ArrayList<AceEventMention> arrayList2 = EventEval.keyEvent.mentions;
            for (int j = 0; j < arrayList2.size(); ++j) {
                AceEventMention aceEventMention = arrayList2.get(j);
                Span span2 = aceEventMention.anchorJetExtent;
                if (span.start() != span2.start()) continue;
                return aceEventMention;
            }
        }
        return null;
    }
}

