/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.Duration;
import org.joda.time.DurationFieldType;
import org.joda.time.MutablePeriod;
import org.joda.time.PeriodType;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.AbstractPeriod;
import org.joda.time.convert.ConverterManager;
import org.joda.time.convert.PeriodConverter;
import org.joda.time.field.FieldUtils;

public abstract class BasePeriod
extends AbstractPeriod
implements ReadablePeriod,
Serializable {
    private static final long serialVersionUID = -2110953284060001145L;
    private PeriodType iType;
    private int[] iValues;

    protected BasePeriod(int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis, PeriodType type) {
        this.iType = type = this.checkPeriodType(type);
        this.setPeriodInternal(years, months, weeks, days, hours, minutes, seconds, millis);
    }

    protected BasePeriod(long startInstant, long endInstant, PeriodType type, Chronology chrono) {
        type = this.checkPeriodType(type);
        chrono = DateTimeUtils.getChronology(chrono);
        this.iType = type;
        this.iValues = chrono.get(this, startInstant, endInstant);
    }

    protected BasePeriod(ReadableInstant startInstant, ReadableInstant endInstant, PeriodType type) {
        type = this.checkPeriodType(type);
        if (startInstant == null && endInstant == null) {
            this.iType = type;
            this.iValues = new int[this.size()];
        } else {
            long startMillis = DateTimeUtils.getInstantMillis(startInstant);
            long endMillis = DateTimeUtils.getInstantMillis(endInstant);
            Chronology chrono = DateTimeUtils.getIntervalChronology(startInstant, endInstant);
            chrono = DateTimeUtils.getChronology(chrono);
            this.iType = type;
            this.iValues = chrono.get(this, startMillis, endMillis);
        }
    }

    protected BasePeriod(ReadablePartial start, ReadablePartial end, PeriodType type) {
        if (start == null || end == null) {
            throw new IllegalArgumentException("ReadablePartial objects must not be null");
        }
        if (start.size() != end.size()) {
            throw new IllegalArgumentException("ReadablePartial objects must have the same set of fields");
        }
        int i = 0;
        int isize = start.size();
        while (i < isize) {
            if (start.getFieldType(i) != end.getFieldType(i)) {
                throw new IllegalArgumentException("ReadablePartial objects must have the same set of fields");
            }
            ++i;
        }
        if (!DateTimeUtils.isContiguous(start)) {
            throw new IllegalArgumentException("ReadablePartial objects must be contiguous");
        }
        this.iType = this.checkPeriodType(type);
        Chronology chrono = DateTimeUtils.getChronology(start.getChronology()).withUTC();
        this.iValues = chrono.get(this, chrono.set(start, 0L), chrono.set(end, 0L));
    }

    protected BasePeriod(ReadableInstant startInstant, ReadableDuration duration, PeriodType type) {
        type = this.checkPeriodType(type);
        long startMillis = DateTimeUtils.getInstantMillis(startInstant);
        long durationMillis = DateTimeUtils.getDurationMillis(duration);
        long endMillis = FieldUtils.safeAdd(startMillis, durationMillis);
        Chronology chrono = DateTimeUtils.getInstantChronology(startInstant);
        this.iType = type;
        this.iValues = chrono.get(this, startMillis, endMillis);
    }

    protected BasePeriod(ReadableDuration duration, ReadableInstant endInstant, PeriodType type) {
        type = this.checkPeriodType(type);
        long durationMillis = DateTimeUtils.getDurationMillis(duration);
        long endMillis = DateTimeUtils.getInstantMillis(endInstant);
        long startMillis = FieldUtils.safeSubtract(endMillis, durationMillis);
        Chronology chrono = DateTimeUtils.getInstantChronology(endInstant);
        this.iType = type;
        this.iValues = chrono.get(this, startMillis, endMillis);
    }

    protected BasePeriod(long duration, PeriodType type, Chronology chrono) {
        type = this.checkPeriodType(type);
        chrono = DateTimeUtils.getChronology(chrono);
        this.iType = type;
        this.iValues = chrono.get(this, duration);
    }

    protected BasePeriod(Object period, PeriodType type, Chronology chrono) {
        PeriodConverter converter = ConverterManager.getInstance().getPeriodConverter(period);
        type = type == null ? converter.getPeriodType(period) : type;
        this.iType = type = this.checkPeriodType(type);
        if (this instanceof ReadWritablePeriod) {
            this.iValues = new int[this.size()];
            chrono = DateTimeUtils.getChronology(chrono);
            converter.setInto((ReadWritablePeriod)((Object)this), period, chrono);
        } else {
            this.iValues = new MutablePeriod(period, type, chrono).getValues();
        }
    }

    protected BasePeriod(int[] values, PeriodType type) {
        this.iType = type;
        this.iValues = values;
    }

    protected PeriodType checkPeriodType(PeriodType type) {
        return DateTimeUtils.getPeriodType(type);
    }

    public PeriodType getPeriodType() {
        return this.iType;
    }

    public int size() {
        return this.iType.size();
    }

    public DurationFieldType getFieldType(int index) {
        return this.iType.getFieldType(index);
    }

    public int getValue(int index) {
        return this.iValues[index];
    }

    public Duration toDurationFrom(ReadableInstant startInstant) {
        long startMillis = DateTimeUtils.getInstantMillis(startInstant);
        Chronology chrono = DateTimeUtils.getInstantChronology(startInstant);
        long endMillis = chrono.add(this, startMillis, 1);
        return new Duration(startMillis, endMillis);
    }

    public Duration toDurationTo(ReadableInstant endInstant) {
        long endMillis = DateTimeUtils.getInstantMillis(endInstant);
        Chronology chrono = DateTimeUtils.getInstantChronology(endInstant);
        long startMillis = chrono.add(this, endMillis, -1);
        return new Duration(startMillis, endMillis);
    }

    private void checkAndUpdate(DurationFieldType type, int[] values, int newValue) {
        int index = this.indexOf(type);
        if (index == -1) {
            if (newValue != 0) {
                throw new IllegalArgumentException("Period does not support field '" + type.getName() + "'");
            }
        } else {
            values[index] = newValue;
        }
    }

    protected void setPeriod(ReadablePeriod period) {
        if (period == null) {
            this.setValues(new int[this.size()]);
        } else {
            this.setPeriodInternal(period);
        }
    }

    private void setPeriodInternal(ReadablePeriod period) {
        int[] newValues = new int[this.size()];
        int i = 0;
        int isize = period.size();
        while (i < isize) {
            DurationFieldType type = period.getFieldType(i);
            int value = period.getValue(i);
            this.checkAndUpdate(type, newValues, value);
            ++i;
        }
        this.iValues = newValues;
    }

    protected void setPeriod(int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis) {
        this.setPeriodInternal(years, months, weeks, days, hours, minutes, seconds, millis);
    }

    private void setPeriodInternal(int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis) {
        int[] newValues = new int[this.size()];
        this.checkAndUpdate(DurationFieldType.years(), newValues, years);
        this.checkAndUpdate(DurationFieldType.months(), newValues, months);
        this.checkAndUpdate(DurationFieldType.weeks(), newValues, weeks);
        this.checkAndUpdate(DurationFieldType.days(), newValues, days);
        this.checkAndUpdate(DurationFieldType.hours(), newValues, hours);
        this.checkAndUpdate(DurationFieldType.minutes(), newValues, minutes);
        this.checkAndUpdate(DurationFieldType.seconds(), newValues, seconds);
        this.checkAndUpdate(DurationFieldType.millis(), newValues, millis);
        this.iValues = newValues;
    }

    protected void setField(DurationFieldType field, int value) {
        this.setFieldInto(this.iValues, field, value);
    }

    protected void setFieldInto(int[] values, DurationFieldType field, int value) {
        int index = this.indexOf(field);
        if (index == -1) {
            if (value != 0 || field == null) {
                throw new IllegalArgumentException("Period does not support field '" + field + "'");
            }
        } else {
            values[index] = value;
        }
    }

    protected void addField(DurationFieldType field, int value) {
        this.addFieldInto(this.iValues, field, value);
    }

    protected void addFieldInto(int[] values, DurationFieldType field, int value) {
        int index = this.indexOf(field);
        if (index == -1) {
            if (value != 0 || field == null) {
                throw new IllegalArgumentException("Period does not support field '" + field + "'");
            }
        } else {
            values[index] = FieldUtils.safeAdd(values[index], value);
        }
    }

    protected void mergePeriod(ReadablePeriod period) {
        if (period != null) {
            this.iValues = this.mergePeriodInto(this.getValues(), period);
        }
    }

    protected int[] mergePeriodInto(int[] values, ReadablePeriod period) {
        int i = 0;
        int isize = period.size();
        while (i < isize) {
            DurationFieldType type = period.getFieldType(i);
            int value = period.getValue(i);
            this.checkAndUpdate(type, values, value);
            ++i;
        }
        return values;
    }

    protected void addPeriod(ReadablePeriod period) {
        if (period != null) {
            this.iValues = this.addPeriodInto(this.getValues(), period);
        }
    }

    protected int[] addPeriodInto(int[] values, ReadablePeriod period) {
        int i = 0;
        int isize = period.size();
        while (i < isize) {
            DurationFieldType type = period.getFieldType(i);
            int value = period.getValue(i);
            if (value != 0) {
                int index = this.indexOf(type);
                if (index == -1) {
                    throw new IllegalArgumentException("Period does not support field '" + type.getName() + "'");
                }
                values[index] = FieldUtils.safeAdd(this.getValue(index), value);
            }
            ++i;
        }
        return values;
    }

    protected void setValue(int index, int value) {
        this.iValues[index] = value;
    }

    protected void setValues(int[] values) {
        this.iValues = values;
    }
}

