/*
 * Decompiled with CFR 0.152.
 */
package tratz.semantics.srl;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import tratz.parse.types.Arc;
import tratz.parse.types.Parse;
import tratz.parse.types.Sentence;
import tratz.parse.types.Token;
import tratz.semantics.srl.SemanticArc;

public class SentenceReaderForSRL {
    private Map<String, String> mCanon = new HashMap<String, String>();

    public Object[] readSentence(BufferedReader reader) throws IOException {
        HashMap<Arc, SemanticArc> arcToSemarc = new HashMap<Arc, SemanticArc>();
        Token root = new Token("[ROOT]", 0);
        ArrayList<Token> tokens = new ArrayList<Token>();
        ArrayList<Arc> arcs = new ArrayList<Arc>();
        String line = null;
        HashMap<Integer, Token> numToToken = new HashMap<Integer, Token>();
        numToToken.put(0, root);
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            if (line.trim().equals("")) {
                if (tokens.size() != 0) break;
                continue;
            }
            lines.add(line);
            String[] split = line.split("\\t+");
            int tokenNum = Integer.parseInt(split[0]);
            String text = this.canon(split[1]);
            Token token = new Token(text, tokenNum);
            String pos = this.canon(split[4]);
            token.setPos(pos);
            tokens.add(token);
            numToToken.put(tokenNum, token);
        }
        for (String l : lines) {
            String[] split = l.split("\\t+");
            int tokenNum = Integer.parseInt(split[0]);
            int head = Integer.parseInt(split[6]);
            String dependency = this.canon(split[7]);
            String truePos = this.canon(split[4]);
            Token t1 = (Token)numToToken.get(tokenNum);
            Token t2 = (Token)numToToken.get(head);
            Arc syntacticArc = new Arc(t1, t2, dependency);
            arcs.add(syntacticArc);
            if (split.length <= 10) continue;
            for (int i = 10; i < split.length; ++i) {
                String posDash;
                String semArc = split[i];
                String[] parts = semArc.split("\\|");
                if (parts[0].startsWith("rel")) {
                    t1.setLexSense(parts[2]);
                    continue;
                }
                String preArrow = parts[0].substring(0, parts[0].indexOf("->"));
                String predicate = parts[parts.length - 1];
                int dashIndex = preArrow.indexOf("-");
                String semType = null;
                semType = dashIndex != -1 ? ((posDash = preArrow.substring(dashIndex + 1)).equals(posDash.toUpperCase()) ? preArrow : preArrow.substring(0, dashIndex)) : preArrow;
                SemanticArc newSemanticArc = new SemanticArc(semType, semArc, predicate);
                SemanticArc oldSemanticArc = (SemanticArc)arcToSemarc.get(syntacticArc);
                if (oldSemanticArc != null) {
                    if (newSemanticArc.getType().equals(oldSemanticArc.getType())) continue;
                    String argCharNew = "" + newSemanticArc.getType().charAt(3);
                    String argCharOld = "" + oldSemanticArc.getType().charAt(3);
                    int argNumNew = -1;
                    int argNumOld = -2;
                    try {
                        argNumNew = Integer.parseInt(argCharNew);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    try {
                        argNumOld = Integer.parseInt(argCharOld);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    if (dependency.endsWith("subj") && argNumNew != -1) {
                        if (argNumOld <= argNumNew) continue;
                        arcToSemarc.put(syntacticArc, newSemanticArc);
                        continue;
                    }
                    if (dependency.matches("advcl|advmod|tmod|purpcl|aux|auxpass|neg")) {
                        if (argNumNew == -1) {
                            arcToSemarc.put(syntacticArc, newSemanticArc);
                            continue;
                        }
                        if (argNumNew <= argNumOld) continue;
                        arcToSemarc.put(syntacticArc, newSemanticArc);
                        continue;
                    }
                    if (argNumNew <= argNumOld) continue;
                    arcToSemarc.put(syntacticArc, newSemanticArc);
                    continue;
                }
                arcToSemarc.put(syntacticArc, newSemanticArc);
            }
        }
        Object[] result = new Object[2];
        if (tokens.size() > 0) {
            Sentence outputSentence = new Sentence(tokens);
            result[0] = new Parse(outputSentence, root, arcs);
            result[1] = arcToSemarc;
        } else {
            result = null;
        }
        return result;
    }

    private String canon(String s) {
        String canon = this.mCanon.get(s);
        if (canon == null) {
            canon = s;
            this.mCanon.put(s, canon);
        }
        return canon;
    }
}

